/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.infra.fx;

import io.sitoolkit.wt.gui.app.script.ScriptFileType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;

public class ScriptDialog {
    FileChooser fileChooser = new FileChooser();

    public ScriptDialog() {
        this.fileChooser.setInitialDirectory(new File("."));
        this.fileChooser.getExtensionFilters().addAll((Collection<FileChooser.ExtensionFilter>)this.getExtensionFilters());
    }

    private List<FileChooser.ExtensionFilter> getExtensionFilters() {
        List<String> allExtentions = Stream.of(ScriptFileType.values()).map(ScriptFileType::getExtentions).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        FileChooser.ExtensionFilter allFillter = new FileChooser.ExtensionFilter("all test script", allExtentions);
        ArrayList<FileChooser.ExtensionFilter> filters = new ArrayList<FileChooser.ExtensionFilter>();
        filters.add(allFillter);
        Stream.of(ScriptFileType.values()).map(type -> new FileChooser.ExtensionFilter(type.getDescription(), type.getExtentions())).forEachOrdered(filters::add);
        return filters;
    }

    public File showOpenDialog(Window ownerWindow) {
        this.fileChooser.setTitle("\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f");
        File file = this.fileChooser.showOpenDialog(ownerWindow);
        if (file != null) {
            this.fileChooser.setInitialDirectory(file.getParentFile());
        }
        return file;
    }

    public File showSaveDialog(Window ownerWindow) {
        this.fileChooser.setTitle("\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u3092\u5225\u540d\u4fdd\u5b58\u3059\u308b");
        File file = this.fileChooser.showSaveDialog(ownerWindow);
        if (file != null) {
            this.fileChooser.setInitialDirectory(file.getParentFile());
        }
        return file;
    }

    public Optional<ScriptFileType> getSelectedFileType() {
        return this.getType(this.fileChooser.getSelectedExtensionFilter());
    }

    private Optional<ScriptFileType> getType(FileChooser.ExtensionFilter extentsionFilter) {
        return Stream.of(ScriptFileType.values()).filter(fileType -> StringUtils.equals(fileType.getDescription(), extentsionFilter.getDescription())).findFirst();
    }
}

