/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.infra.fx;

import io.sitoolkit.wt.gui.infra.fx.FileWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeItem;
import javafx.scene.image.ImageView;

public final class FileTreeItem
extends CheckBoxTreeItem<FileWrapper> {
    private boolean isLeaf;
    private boolean isFirstTimeLeaf = true;
    private boolean isSelectable = true;

    public FileTreeItem(File file) {
        super(new FileWrapper(file));
        String url = file.isDirectory() ? "/icon/ic_folder_open_black_18dp_1x.png" : "/icon/ic_description_black_18dp_1x.png";
        this.setGraphic(new ImageView(url));
    }

    public List<File> getSelectedFiles() {
        ArrayList<File> selectedFiles = new ArrayList<File>();
        if (this.isSelected()) {
            selectedFiles.add(((FileWrapper)this.getValue()).getFile());
        }
        for (TreeItem treeItem : this.getChildren()) {
            selectedFiles.addAll(((FileTreeItem)treeItem).getSelectedFiles());
        }
        return selectedFiles;
    }

    @Override
    public boolean isLeaf() {
        if (this.isFirstTimeLeaf) {
            this.isFirstTimeLeaf = false;
            FileWrapper file = (FileWrapper)this.getValue();
            this.isLeaf = file.getFile().isFile();
        }
        return this.isLeaf;
    }

    public void buildChildren() {
        File[] files;
        FileWrapper file = (FileWrapper)this.getValue();
        if (file != null && file.getFile().isDirectory() && (files = file.getFile().listFiles()) != null) {
            for (File childFile : files) {
                this.addChild(childFile);
            }
        }
    }

    public boolean isSelectable() {
        return this.isSelectable;
    }

    public FileTreeItem addChild(File childFile) {
        FileTreeItem child = new FileTreeItem(childFile);
        child.isSelectable = this.isSelectable;
        child.buildChildren();
        this.getChildren().add(child);
        return child;
    }
}

