/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.infra.fx;

import com.sun.nio.file.SensitivityWatchEventModifier;
import io.sitoolkit.wt.gui.infra.fx.FileTreeItem;
import io.sitoolkit.wt.gui.infra.fx.FileWrapper;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.util.infra.concurrent.ExecutorContainer;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.control.TreeItem;

public class FileSystemWatchService {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(FileSystemWatchService.class);
    private WatchService watcher;
    private Map<Path, FileTreeItem> pathItemMap = new HashMap<Path, FileTreeItem>();
    private Map<WatchKey, Path> watchKeyPathMap = new HashMap<WatchKey, Path>();
    private boolean watching = true;

    public void register(FileTreeItem item) {
        File rootFile = ((FileWrapper)item.getValue()).getFile();
        Path path = ((FileWrapper)item.getValue()).getFile().getAbsoluteFile().toPath();
        this.pathItemMap.put(path, item);
        if (!rootFile.isDirectory()) {
            return;
        }
        try {
            WatchKey watchKey = path.register(this.watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE}, SensitivityWatchEventModifier.HIGH);
            this.watchKeyPathMap.put(watchKey, path);
            LOG.debug("app.filePathRegistered", path.toAbsolutePath(), watchKey);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (TreeItem treeItem : item.getChildren()) {
            this.register((FileTreeItem)treeItem);
        }
    }

    public void init() {
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ExecutorContainer.get().submit(() -> {
            while (this.watching) {
                this.watch();
            }
        });
    }

    public void destroy() {
        if (this.watcher != null) {
            try {
                this.watching = false;
                this.watcher.close();
            }
            catch (IOException e) {
                LOG.error("app.exceptionLocalizedMsg", e.getLocalizedMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void watch() {
        WatchKey watchKey = null;
        try {
            watchKey = this.watcher.take();
            Path eventSourcePath = this.watchKeyPathMap.get(watchKey);
            FileTreeItem eventSourceItem = this.pathItemMap.get(eventSourcePath);
            for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                LOG.debug("app.watchParams", watchKey, watchEvent.kind(), watchEvent.context(), eventSourcePath);
                Object context = watchEvent.context();
                if (context == null || !(context instanceof Path)) continue;
                Path eventTargetPath = eventSourcePath.resolve((Path)context);
                if (StandardWatchEventKinds.ENTRY_CREATE.equals(watchEvent.kind())) {
                    this.create(eventSourcePath, eventTargetPath, eventSourceItem);
                    continue;
                }
                if (!StandardWatchEventKinds.ENTRY_DELETE.equals(watchEvent.kind())) continue;
                this.delete(eventTargetPath, eventSourceItem);
            }
        }
        catch (ClosedWatchServiceException e) {
            LOG.info("app.ignorableException", e.getClass());
        }
        catch (Exception e) {
            LOG.error("app.exceptionOccurs", e);
        }
        finally {
            if (watchKey != null) {
                watchKey.reset();
            }
        }
    }

    void create(Path eventSourcePath, Path eventTargetPath, FileTreeItem eventSourceItem) {
        FileTreeItem childItem = eventSourceItem.addChild(eventTargetPath.toFile());
        LOG.debug("app.createPath", eventTargetPath, childItem);
        this.register(childItem);
    }

    void delete(Path eventTargetPath, FileTreeItem eventSourceItem) {
        FileTreeItem eventTargetItem = this.pathItemMap.get(eventTargetPath);
        eventSourceItem.getChildren().remove(eventTargetItem);
        this.pathItemMap.remove(eventTargetPath);
        WatchKey removingWatchKey = null;
        for (Map.Entry<WatchKey, Path> entry : this.watchKeyPathMap.entrySet()) {
            if (!entry.getValue().equals(eventTargetPath)) continue;
            removingWatchKey = entry.getKey();
        }
        this.watchKeyPathMap.remove(removingWatchKey);
        LOG.debug("app.deletePath", eventTargetPath, eventTargetItem, removingWatchKey);
    }
}

