/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.infra.config;

import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.util.infra.util.StrUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class PropertyManager {
    private static final String FILE_NAME = "sit-wt-app.properties";
    private static final String SEPARATOR = ",";
    private static final String BASE_URL = "baseUrl";
    private static final String BASE_URL_LIMIT = "baseUrlLimit";
    private static final String CSV_CHARSET = "script.file.csv.charset";
    private static final String CSV_BOM = "script.file.csv.bom";
    private static final SitLogger LOG = SitLoggerFactory.getLogger(PropertyManager.class);
    private static final PropertyManager pm = new PropertyManager();
    private Properties prop = new Properties();
    private File baseDir;
    private List<String> baseUrls = new ArrayList<String>();

    private PropertyManager() {
    }

    public static PropertyManager get() {
        return pm;
    }

    public void load(File baseDir) {
        this.baseDir = baseDir;
        File propertyFile = new File(baseDir, FILE_NAME);
        if (!propertyFile.exists()) {
            LOG.debug("app.noPropertyFile", baseDir.getAbsolutePath());
            return;
        }
        try (FileInputStream fis = new FileInputStream(propertyFile);){
            this.prop.load(fis);
            LOG.info("app.loadProperties", this.prop);
            List<String> savedBaseUrls = Arrays.asList(this.getProp(BASE_URL).split(SEPARATOR));
            savedBaseUrls = savedBaseUrls.subList(0, Math.min(savedBaseUrls.size(), this.getBaseUrlLimit()));
            this.baseUrls.addAll(savedBaseUrls);
        }
        catch (IOException e) {
            LOG.warn("app.loadPropertiesFailed", e);
        }
    }

    public void save() {
        if (this.baseDir == null) {
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(new File(this.baseDir, FILE_NAME), false);){
            this.setProp(BASE_URL, StrUtils.join(this.baseUrls));
            this.setProp(CSV_CHARSET, this.getCsvCharset().name());
            this.setProp(CSV_BOM, String.valueOf(this.getCsvHasBOM()));
            this.prop.store(fos, "SI-Toolkit for Web Testing");
            LOG.info("app.saveProperties", this.prop);
        }
        catch (IOException e) {
            LOG.warn("app.savePropertiesFailed", e);
        }
    }

    public void setBaseUrls(List<String> baseUrls) {
        this.baseUrls = baseUrls;
    }

    public List<String> getBaseUrls() {
        return this.baseUrls;
    }

    public int getBaseUrlLimit() {
        return Integer.parseInt(this.getProp(BASE_URL_LIMIT, "5"));
    }

    public Charset getCsvCharset() {
        return Charset.forName(this.getProp(CSV_CHARSET, "UTF-8"));
    }

    public boolean getCsvHasBOM() {
        return Boolean.valueOf(this.getProp(CSV_BOM, "true"));
    }

    private String getProp(String key) {
        return this.getProp(key, "");
    }

    private String getProp(String key, String defaultValue) {
        return this.prop.getProperty(key, defaultValue);
    }

    private void setProp(String key, String value) {
        this.prop.setProperty(key, value);
    }
}

