/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.domain.sample;

import io.sitoolkit.util.buildtoolhelper.process.StdoutListener;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;

public class JettyMavenPluginStdoutListener
implements StdoutListener {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(JettyMavenPluginStdoutListener.class);
    private volatile int exitLevel = -1;

    @Override
    public void nextLine(String line) {
        if (line == null || line.isEmpty()) {
            return;
        }
        if ("[INFO] Started Jetty Server".equals(line)) {
            this.exitLevel = 0;
        } else if ("[INFO] Jetty server exiting.".equals(line)) {
            this.exitLevel = 1;
        } else if ("[INFO] BUILD FAILURE".equals(line)) {
            this.exitLevel = 2;
        }
    }

    public boolean isSuccess() {
        while (this.exitLevel < 0) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                LOG.warn("app.noMsg", e);
            }
        }
        return this.exitLevel == 0;
    }
}

