/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.domain.project;

import java.io.File;
import java.nio.file.Path;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

public class ProjectState {
    private File pomFile;
    private File baseDir;
    private BooleanProperty running = new SimpleBooleanProperty();
    private BooleanProperty loaded = new SimpleBooleanProperty();
    private BooleanProperty browsing = new SimpleBooleanProperty();
    private BooleanProperty debugging = new SimpleBooleanProperty();
    private BooleanProperty locking = new SimpleBooleanProperty();
    private BooleanProperty operating = new SimpleBooleanProperty();

    public void setState(State state) {
        this.loaded.set(state == State.LOADED);
        this.running.set(state == State.RUNNING);
        this.browsing.set(state == State.BROWSING);
        this.debugging.set(state == State.DEBUGGING);
        this.locking.set(state == State.LOCKING);
        this.operating.set(state == State.OPERATING);
    }

    public BooleanProperty isRunning() {
        return this.running;
    }

    public BooleanProperty isLoaded() {
        return this.loaded;
    }

    public BooleanProperty isBrowsing() {
        return this.browsing;
    }

    public BooleanProperty isDebugging() {
        return this.debugging;
    }

    public BooleanProperty isLocking() {
        return this.locking;
    }

    public BooleanProperty isOperating() {
        return this.operating;
    }

    public void init(File pomFile) {
        this.pomFile = pomFile;
        this.baseDir = pomFile.getAbsoluteFile().getParentFile();
        this.setState(State.LOADED);
    }

    public void reset() {
        this.setState(State.LOADED);
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public Path getBaseDirPath() {
        return this.getBaseDir().toPath();
    }

    public static enum State {
        NOT_LOADED,
        LOADED,
        RUNNING,
        DEBUGGING,
        BROWSING,
        LOCKING,
        OPERATING;

    }
}

