/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.app.test;

import io.sitoolkit.wt.app.config.RuntimeConfig;
import io.sitoolkit.wt.app.test.TestRunner;
import io.sitoolkit.wt.domain.debug.DebugSupport;
import io.sitoolkit.wt.gui.app.test.TestExitCallback;
import io.sitoolkit.wt.gui.domain.test.TestRunParams;
import io.sitoolkit.wt.infra.PropertyManager;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.util.infra.concurrent.ExecutorContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class TestService {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(TestService.class);
    private TestRunner runner = new TestRunner();
    private Map<String, ConfigurableApplicationContext> ctxMap = new HashMap<String, ConfigurableApplicationContext>();

    public String runTest(TestRunParams params, TestExitCallback callback) {
        if (params.getTargetScripts() == null) {
            return null;
        }
        String sessionId = UUID.randomUUID().toString();
        ExecutorContainer.get().execute(() -> {
            try {
                System.setProperty("driver.type", params.getDriverType());
                String profile2 = "android".equals(params.getDriverType()) || "ios".equals(params.getDriverType()) ? "mobile" : "pc";
                AnnotationConfigApplicationContext appCtx = new AnnotationConfigApplicationContext();
                appCtx.register(RuntimeConfig.class);
                appCtx.getEnvironment().addActiveProfile(profile2);
                appCtx.refresh();
                this.ctxMap.put(sessionId, appCtx);
                try {
                    PropertyManager runtimePm = appCtx.getBean(PropertyManager.class);
                    runtimePm.setBaseUrl(params.getBaseUrl());
                    runtimePm.setDebug(params.isDebug());
                    DebugSupport debugSupport = appCtx.getBean(DebugSupport.class);
                    debugSupport.setListener(params.getDebugListener());
                    callback.callback(this.runner.runScript(params.getTargetScripts(), params.isParallel(), false));
                }
                catch (Exception e) {
                    LOG.error("app.unexpectedException", e);
                    callback.callback(Collections.emptyList());
                }
                finally {
                    appCtx.close();
                    this.ctxMap.remove(sessionId);
                }
            }
            catch (Exception e) {
                LOG.error("app.unexpectedException", e);
                callback.callback(Collections.emptyList());
            }
        });
        return sessionId;
    }

    public void pause(String sessionId) {
        this.getDebugSupport(sessionId).pause();
    }

    public void restart(String sessionId, String stepNo) {
        this.getDebugSupport(sessionId).restart(stepNo);
    }

    public void forward(String sessionId) {
        this.getDebugSupport(sessionId).forward();
    }

    public void back(String sessionId) {
        this.getDebugSupport(sessionId).back();
    }

    public void export(String sessionId) {
        this.getDebugSupport(sessionId).export();
    }

    public void checkLocator(String sessionId, String locatorStr) {
        this.getDebugSupport(sessionId).checkLocator(locatorStr);
    }

    public void stopTest(String sessionId) {
        ConfigurableApplicationContext appCtx = this.ctxMap.get(sessionId);
        PropertyManager runtimePm = appCtx.getBean(PropertyManager.class);
        if (runtimePm.isDebug() && this.getDebugSupport(sessionId).isPaused()) {
            this.getDebugSupport(sessionId).exit();
        } else {
            appCtx.close();
        }
        this.ctxMap.remove(sessionId);
    }

    public void destroy() {
        this.ctxMap.values().stream().forEach(ConfigurableApplicationContext::close);
    }

    private DebugSupport getDebugSupport(String sessionId) {
        ConfigurableApplicationContext appCtx = this.ctxMap.get(sessionId);
        return appCtx.getBean(DebugSupport.class);
    }
}

