/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.app.script;

import io.sitoolkit.wt.app.config.ExtConfig;
import io.sitoolkit.wt.app.ope2script.ChromiumOpener;
import io.sitoolkit.wt.app.page2script.Page2Script;
import io.sitoolkit.wt.app.page2script.Page2ScriptConfig;
import io.sitoolkit.wt.app.test.TestCaseReader;
import io.sitoolkit.wt.app.test.TestScriptGenerator;
import io.sitoolkit.wt.domain.operation.OperationConverter;
import io.sitoolkit.wt.domain.testscript.TestScript;
import io.sitoolkit.wt.domain.testscript.TestScriptDao;
import io.sitoolkit.wt.gui.app.script.ScriptFileType;
import io.sitoolkit.wt.gui.domain.script.CaseNoCache;
import io.sitoolkit.wt.gui.infra.config.PropertyManager;
import io.sitoolkit.wt.util.infra.concurrent.ExecutorContainer;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Resource;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class ScriptService {
    CaseNoCache cache = new CaseNoCache();
    @Resource
    TestScriptDao dao;
    @Resource
    io.sitoolkit.wt.infra.PropertyManager runtimePm;
    Page2Script page2script;
    ChromiumOpener chromiumOpener = new ChromiumOpener();
    ConfigurableApplicationContext pageCtx;
    @Resource
    TestCaseReader testCaseReader;
    OperationConverter operationConverter = new OperationConverter();
    @Resource
    TestScriptGenerator testScriptGenerator;

    public void loadProject() {
        PropertyManager pm = PropertyManager.get();
        this.runtimePm.setCsvCharset(pm.getCsvCharset());
        this.runtimePm.setCsvHasBOM(pm.getCsvHasBOM());
    }

    public TestScript read(File file) {
        while (!this.initialized()) {
        }
        return this.dao.load(file, "TestScript", false);
    }

    public void write(TestScript testScript) {
        this.dao.write(testScript.getScriptFile(), testScript.getTestStepList(), testScript.getHeaders(), true);
    }

    private synchronized boolean initialized() {
        return this.dao != null;
    }

    public void page2script(String driverType, String baseUrl) {
        this.pageCtx = new AnnotationConfigApplicationContext(Page2ScriptConfig.class, ExtConfig.class);
        this.page2script = this.pageCtx.getBean(Page2Script.class);
        this.page2script.setOpenScript(false);
        this.page2script.openBrowser(baseUrl, driverType);
    }

    public void ope2script(String baseUrl) {
        ExecutorContainer.get().execute(() -> this.chromiumOpener.open(baseUrl));
    }

    public void quitOperating() {
        this.chromiumOpener.close();
    }

    public List<String> readCaseNo(File testScript) {
        List<String> caseNos = this.cache.getCaseNosIfNotModified(testScript);
        if (caseNos != null) {
            return caseNos;
        }
        List<String> readCaseNos = this.testCaseReader.getTestCase(testScript.getAbsolutePath());
        this.cache.putCaesNos(testScript, readCaseNos);
        return readCaseNos;
    }

    public void write(TestScript testScript, Optional<ScriptFileType> scriptFileType) {
        this.doWithScriptFileType(scriptFileType, () -> this.write(testScript));
    }

    public TestScript read(File file, Optional<ScriptFileType> scriptFileType) {
        return this.doWithScriptFileType(scriptFileType, () -> this.read(file));
    }

    private <T> T doWithScriptFileType(Optional<ScriptFileType> scriptFileType, Supplier<T> s) {
        Charset charset = this.runtimePm.getCsvCharset();
        boolean hasBom = this.runtimePm.isCsvHasBOM();
        scriptFileType.ifPresent(ft -> {
            if (ft.isTextFile()) {
                this.runtimePm.setCsvCharset(ft.getCharset());
                this.runtimePm.setCsvHasBOM(ft.isHasBom());
            }
        });
        T result = s.get();
        this.runtimePm.setCsvCharset(charset);
        this.runtimePm.setCsvHasBOM(hasBom);
        return result;
    }

    private void doWithScriptFileType(Optional<ScriptFileType> scriptFileType, Runnable r) {
        this.doWithScriptFileType(scriptFileType, () -> {
            r.run();
            return null;
        });
    }

    public Path export() {
        this.page2script.generateFromPage();
        return this.page2script.getCreateFile();
    }

    public void quitBrowsing() {
        this.pageCtx.close();
    }

    public void generateNewScript(Path destFile) {
        this.testScriptGenerator.generateNewScript(destFile);
    }
}

