/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.testscript;

import io.sitoolkit.wt.domain.testscript.TestScript;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.resource.MessageManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class TestScriptConvertUtils
implements ApplicationContextAware {
    protected ApplicationContext appCtx;
    private static Map<String, String> cellNameMap;
    private static String stepNo;
    private static String itemName;
    private static String operation;
    private static String locatorStyle;
    private static String locator;
    private static String dataStyle;
    private static String screenshot;
    private static String breakPoint;
    private static String caseNoPrefix;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appCtx = applicationContext;
    }

    private static void initCellNameMap() {
        cellNameMap = new HashMap<String, String>();
        cellNameMap.put(stepNo, TestScriptConvertUtils.getCellName(stepNo));
        cellNameMap.put(itemName, TestScriptConvertUtils.getCellName(itemName));
        cellNameMap.put(operation, TestScriptConvertUtils.getCellName(operation));
        cellNameMap.put(locatorStyle, TestScriptConvertUtils.getCellName(locatorStyle));
        cellNameMap.put(locator, TestScriptConvertUtils.getCellName(locator));
        cellNameMap.put(dataStyle, TestScriptConvertUtils.getCellName(dataStyle));
        cellNameMap.put(screenshot, TestScriptConvertUtils.getCellName(screenshot));
        cellNameMap.put(breakPoint, TestScriptConvertUtils.getCellName(breakPoint));
        cellNameMap.put(caseNoPrefix, TestScriptConvertUtils.getCellName(caseNoPrefix));
    }

    private static String getCellName(String name) {
        return MessageManager.getMessage("testScript-header-" + name);
    }

    private static String getValue(Map<String, String> row, String key) {
        if (cellNameMap == null) {
            TestScriptConvertUtils.initCellNameMap();
        }
        return row.get(cellNameMap.get(key));
    }

    public static void loadStep(TestStep testStep, Map<String, String> row, List<String> caseNoList) {
        testStep.setNo(TestScriptConvertUtils.getValue(row, stepNo));
        testStep.setItemName(TestScriptConvertUtils.getValue(row, itemName));
        testStep.setOperationName(TestScriptConvertUtils.getValue(row, operation));
        testStep.getLocator().setType(TestScriptConvertUtils.getValue(row, locatorStyle));
        testStep.getLocator().setValue(TestScriptConvertUtils.getValue(row, locator));
        testStep.setDataType(TestScriptConvertUtils.getValue(row, dataStyle));
        testStep.setScreenshotTiming(TestScriptConvertUtils.getValue(row, screenshot));
        testStep.setBreakPoint(TestScriptConvertUtils.getValue(row, breakPoint));
        HashMap<String, String> testData = new HashMap<String, String>();
        String casePrefix = new TestScript().getCaseNoPrefix();
        caseNoList.stream().forEach(s -> testData.put((String)s, (String)row.get(casePrefix + s)));
        testStep.setTestData(testData);
    }

    public static List<String> createHeaderRow(List<String> caseNoList) {
        if (cellNameMap == null) {
            TestScriptConvertUtils.initCellNameMap();
        }
        String casePrefix = new TestScript().getCaseNoPrefix();
        Stream<String> itemStream = Stream.of(stepNo, itemName, operation, locatorStyle, locator, dataStyle, screenshot, breakPoint).map(cellNameMap::get);
        Stream<String> caseStream = caseNoList.stream().map(caseNo -> casePrefix + caseNo);
        return Stream.concat(itemStream, caseStream).collect(Collectors.toList());
    }

    public static List<String> createRow(TestStep testStep, List<String> caseNoList) {
        ArrayList<String> row = new ArrayList<String>();
        row.add(testStep.getNo());
        row.add(testStep.getItemName());
        row.add(testStep.getOperationName());
        row.add(testStep.getLocator().getType());
        row.add(testStep.getLocator().getValue());
        row.add(testStep.getDataType());
        row.add(testStep.getScreenshotTiming().getLabel());
        row.add(testStep.getBreakPoint());
        caseNoList.stream().map(testStep.getTestData()::get).forEachOrdered(row::add);
        return row;
    }

    static {
        stepNo = "stepNo";
        itemName = "itemName";
        operation = "operation";
        locatorStyle = "locatorStyle";
        locator = "locator";
        dataStyle = "dataStyle";
        screenshot = "screenshot";
        breakPoint = "breakPoint";
        caseNoPrefix = "caseNoPrefix";
    }
}

