/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.testscript;

import io.sitoolkit.wt.infra.ELSupport;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class Locator {
    @Resource
    ELSupport el;
    private static final Locator NA = new Locator();
    private String type = Type.na.getLabel();
    private String value = "";
    private String attributeName = "";

    public Locator() {
    }

    private Locator(Type type, String value) {
        this.type = type.getLabel();
        this.setValue(value);
    }

    public boolean equalsByName(String name) {
        Type type = this.getTypeVo();
        switch (type) {
            case name: {
                return this.value.equals(name);
            }
            case xpath: {
                return this.value.contains("[@name='" + name + "']");
            }
            case css: {
                return this.value.contains("[name=" + name + "]");
            }
        }
        return false;
    }

    public Type getTypeVo() {
        return Type.decode(this.getType());
    }

    public void setTypeVo(Type type) {
        this.setType(type == null ? Type.na.name() : type.name());
    }

    public String getValue() {
        return this.el == null ? this.value : this.el.evaluate(this.value);
    }

    public void setValue(String value) {
        String attrName = StringUtils.substringAfterLast(value, "@");
        if (StringUtils.isNotEmpty(attrName) && !StringUtils.containsAny((CharSequence)attrName, "/", "[", "(")) {
            value = StringUtils.substringBeforeLast(value, "@");
            this.attributeName = attrName;
        }
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isNa() {
        return Type.na.equals((Object)this.getTypeVo());
    }

    public String toString() {
        return Type.na.name().equals(this.getType()) ? this.getValue() : this.getType() + "=" + this.getValue();
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public static Locator build(String type, String value) {
        return new Locator(Type.decode(type), value);
    }

    public static Locator build(String str) {
        if (StringUtils.isBlank(str)) {
            return NA;
        }
        if (str.startsWith("//")) {
            return Locator.build(Type.xpath.name(), str);
        }
        Locator locator = Locator.buidlByPrefix(str, "=");
        if (locator == null) {
            locator = Locator.buidlByPrefix(str, " ");
        }
        if (locator == null) {
            locator = Locator.build(Type.na.name(), str);
        }
        return locator;
    }

    private static Locator buidlByPrefix(String str, String _prefix) {
        for (Type type : Type.values()) {
            String prefix = type.name() + _prefix;
            if (!str.startsWith(prefix)) continue;
            return Locator.build(type.name(), StringUtils.substringAfter(str, prefix));
        }
        return null;
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty(this.type) && StringUtils.isEmpty(this.value);
    }

    public static enum Type {
        id,
        css,
        name,
        xpath,
        link,
        tag,
        title,
        url,
        case_no,
        os_command,
        variable,
        testscript_file,
        sql_file,
        na("");

        public static List<Type> SELECTOR_TYPES;
        public static List<Type> SELECTOR_WITH_LINK_TYPES;
        public static List<Type> SELECTOR_WITH_LINK_CAN_BE_BLANK_TYPES;
        public static List<Type> TITLE_TYPES;
        private String label;

        private Type() {
            this.label = this.name();
        }

        private Type(String label) {
            this.label = label;
        }

        public static Type decode(String code) {
            for (Type type : Type.values()) {
                if (!type.name().equals(code)) continue;
                return type;
            }
            return na;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        static {
            SELECTOR_TYPES = Arrays.asList(id, name, tag, css, xpath);
            SELECTOR_WITH_LINK_TYPES = Arrays.asList(id, name, tag, link, css, xpath);
            SELECTOR_WITH_LINK_CAN_BE_BLANK_TYPES = Arrays.asList(na, id, name, tag, link, css, xpath);
            TITLE_TYPES = Arrays.asList(na, title);
        }
    }
}

