/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.tester;

import io.sitoolkit.wt.domain.debug.DebugSupport;
import io.sitoolkit.wt.domain.evidence.DialogScreenshotSupport;
import io.sitoolkit.wt.domain.evidence.Evidence;
import io.sitoolkit.wt.domain.evidence.EvidenceManager;
import io.sitoolkit.wt.domain.evidence.LogLevelVo;
import io.sitoolkit.wt.domain.evidence.LogRecord;
import io.sitoolkit.wt.domain.evidence.Screenshot;
import io.sitoolkit.wt.domain.evidence.ScreenshotTaker;
import io.sitoolkit.wt.domain.evidence.ScreenshotTiming;
import io.sitoolkit.wt.domain.operation.OperationResult;
import io.sitoolkit.wt.domain.tester.OperationSupport;
import io.sitoolkit.wt.domain.tester.TestContext;
import io.sitoolkit.wt.domain.tester.TestResult;
import io.sitoolkit.wt.domain.testscript.TestScript;
import io.sitoolkit.wt.domain.testscript.TestScriptCatalog;
import io.sitoolkit.wt.domain.testscript.TestScriptDao;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.PropertyManager;
import io.sitoolkit.wt.infra.TestException;
import io.sitoolkit.wt.infra.VerifyException;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.resource.MessageManager;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

public class Tester {
    protected final SitLogger log = SitLoggerFactory.getLogger(this.getClass());
    @Resource
    TestContext current;
    @Resource
    DebugSupport debug;
    @Resource
    DialogScreenshotSupport dialog;
    @Resource
    EvidenceManager em;
    @Resource
    ScreenshotTaker screenshotTaker;
    @Resource
    TestScriptDao dao;
    @Resource
    TestScriptCatalog catalog;
    @Resource
    PropertyManager pm;
    @Resource
    OperationSupport operationSupport;
    private boolean scriptLoaded = false;
    private TestScript testScript;

    public void setUp(String caseNo) {
        this.current.reset();
        this.current.setCaseNo(caseNo);
        this.current.setScriptName(this.testScript.getName());
    }

    public void prepare(String scriptPath, String sheetName, String caseNo) {
        this.testScript = this.catalog.get(scriptPath, sheetName);
        this.current.setTestScript(this.testScript);
        this.current.setScriptName(this.testScript.getName());
        this.current.reset();
        this.log.debug("prepare.test", this.current);
    }

    public void setUpClass(String testScriptPath, String sheetName) {
        if (!this.isScriptLoaded()) {
            this.log.info("script.load2", testScriptPath, sheetName);
            this.testScript = this.catalog.get(testScriptPath, sheetName);
            this.current.setTestScript(this.testScript);
            if (this.pm.isDebug()) {
                this.log.info("test.step.last");
                TestStep lastStep = this.testScript.getLastStep();
                lastStep.setBreakPoint("y");
            }
        }
    }

    public void tearDown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult operate(String caseNo) {
        if (StringUtils.isEmpty(caseNo)) {
            caseNo = this.testScript.getCaseNoMap().keySet().iterator().next();
        } else if (!this.testScript.containsCaseNo(caseNo)) {
            String msg = MessageManager.getMessage("case.number.error", caseNo) + this.testScript.getCaseNoMap().keySet();
            throw new TestException(msg);
        }
        this.current.setCaseNo(caseNo);
        this.dialog.checkReserve(this.testScript.getTestStepList(), caseNo);
        this.log.info("case.execute", caseNo);
        ArrayList<Exception> ngList = new ArrayList<Exception>();
        TestResult result = new TestResult();
        Evidence evidence = this.em.createEvidence(this.current.getScriptName(), caseNo);
        TestStep testStep = null;
        try {
            this.debug.start();
            do {
                testStep = this.current.getTestStep();
                this.dialog.reserveWindowRect(testStep.getNo());
                try {
                    this.operateOneScript(testStep, this.current.getCaseNo(), evidence);
                }
                catch (VerifyException e) {
                    ngList.add(e);
                    result.add(e);
                    evidence.addLogRecord(LogRecord.create(this.log, LogLevelVo.ERROR, testStep, "unexpected.result", e.getLocalizedMessage()));
                    if (!this.operationSupport.isDbVerify(testStep.getOperation())) {
                        this.addScreenshot(evidence, ScreenshotTiming.ON_ERROR);
                    }
                    if (!this.pm.isDebug()) continue;
                    this.debug.pause();
                }
                catch (Exception e) {
                    if (this.pm.isDebug()) {
                        ngList.add(e);
                        evidence.addLogRecord(LogRecord.create(this.log, LogLevelVo.ERROR, testStep, "unexpected.error2", e.getLocalizedMessage()));
                        this.log.debug("exception", e);
                        if (!this.operationSupport.isDbVerify(testStep.getOperation())) {
                            this.addScreenshot(evidence, ScreenshotTiming.ON_ERROR);
                        }
                        this.debug.pause();
                        continue;
                    }
                    throw e;
                }
            } while (this.debug.next());
        }
        catch (Exception e) {
            evidence.addLogRecord(LogRecord.create(this.log, LogLevelVo.ERROR, testStep, "unexpected.error2", e.getLocalizedMessage()));
            this.log.debug("exception", e);
            if (!this.operationSupport.isDbVerify(testStep.getOperation())) {
                this.addScreenshot(evidence, ScreenshotTiming.ON_ERROR);
            }
            result.setErrorCause(e);
        }
        finally {
            result.setEvidenceFile(this.em.flushEvidence(evidence));
        }
        return result;
    }

    private void operateOneScript(TestStep testStep, String caseNo, Evidence evidence) {
        testStep.setCurrentCaseNo(caseNo);
        if (testStep.isSkip()) {
            this.log.info("case.skip", caseNo, testStep.getNo(), testStep.getItemName());
            return;
        }
        if (testStep.dialogScreenshot()) {
            this.addScreenshot(evidence, ScreenshotTiming.ON_DIALOG);
        } else if (testStep.beforeScreenshot()) {
            this.addScreenshot(evidence, ScreenshotTiming.BEFORE_OPERATION);
        }
        OperationResult result = testStep.getOperation().operate(testStep);
        evidence.addLogRecords(result.getRecords());
        if (testStep.afterScreenshot()) {
            this.addScreenshot(evidence, ScreenshotTiming.AFTER_OPERATION);
        }
        evidence.commitScreenshot();
        try {
            Thread.sleep(this.pm.getOperationWait());
        }
        catch (InterruptedException e) {
            this.log.warn("thread.sleep.error", e);
            Thread.currentThread().interrupt();
        }
    }

    private void addScreenshot(Evidence evidence, ScreenshotTiming timing) {
        Screenshot screenshot = this.screenshotTaker.get(timing);
        evidence.addScreenshot(screenshot, this.current.getScreenshotTiming());
        this.em.moveScreenshot(evidence, this.current.getTestStepNo(), this.current.getItemName());
    }

    public boolean isScriptLoaded() {
        return this.scriptLoaded;
    }

    public TestScript getTestScript() {
        return this.testScript;
    }
}

