/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.tester;

import io.sitoolkit.wt.infra.VerifyException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TestResult {
    private List<VerifyException> verifyExceptions = new ArrayList<VerifyException>();
    private Throwable errorCause;
    private Path evidenceFile;

    public String buildReason() {
        StringBuilder sb = new StringBuilder();
        sb.append("\u30c6\u30b9\u30c8\u5b9f\u884c\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        if (this.errorCause != null) {
            sb.append("\n\t");
            sb.append(ExceptionUtils.getStackTrace(this.errorCause));
        }
        for (VerifyException ve : this.verifyExceptions) {
            sb.append("\n\t");
            sb.append(ExceptionUtils.getStackTrace(ve));
        }
        return sb.toString();
    }

    public boolean isSuccess() {
        return this.errorCause == null && this.verifyExceptions.isEmpty();
    }

    public void add(VerifyException ve) {
        this.verifyExceptions.add(ve);
    }

    public int getFailCount() {
        return this.verifyExceptions.size();
    }

    public Throwable getErrorCause() {
        return this.errorCause;
    }

    public void setErrorCause(Throwable errorCause) {
        this.errorCause = errorCause;
    }

    @Generated
    public Path getEvidenceFile() {
        return this.evidenceFile;
    }

    @Generated
    public void setEvidenceFile(Path evidenceFile) {
        this.evidenceFile = evidenceFile;
    }
}

