/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.pageload.selenium;

import io.sitoolkit.wt.domain.guidance.GuidanceUtils;
import io.sitoolkit.wt.domain.pageload.PageContext;
import io.sitoolkit.wt.domain.pageload.PageListener;
import io.sitoolkit.wt.infra.PropertyManager;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.openqa.selenium.WebDriver;

public class SeleniumPageLietener
implements PageListener {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(SeleniumPageLietener.class);
    @Resource
    WebDriver driver;
    @Resource
    PropertyManager pm;
    private String guidanceFile = "guidance/guidance-page2script.html";
    private String[] guidanceResources = new String[]{this.guidanceFile, "guidance/css/bootstrap.min.css", "guidance/css/style.css", "guidance/js/open.js", "guidance/img/ic_file_download_black_18dp_1x.png", "guidance/img/ic_stop_black_18dp_1x.png"};

    @Override
    public void setUpPage(PageContext ctx) {
        this.driver.manage().timeouts().implicitlyWait(0L, TimeUnit.MILLISECONDS);
        ctx.setTitle(this.driver.getTitle());
        ctx.setUrl(this.driver.getCurrentUrl());
    }

    @Override
    public void tearDownPage(PageContext ctx) {
        this.driver.manage().timeouts().implicitlyWait(this.pm.getImplicitlyWait(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void setUp() {
        GuidanceUtils.retrieve(this.guidanceResources);
        String driverType = this.driver.toString();
        LOG.info("browser.start", driverType);
        String baseUrl = this.pm.getBaseUrl();
        this.driver.get(GuidanceUtils.appendBaseUrl(this.guidanceFile, baseUrl));
    }

    @Override
    public void tearDown() {
    }
}

