/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.pageload.selenium;

import io.sitoolkit.wt.domain.pageload.ElementId;
import io.sitoolkit.wt.domain.pageload.PageContext;
import io.sitoolkit.wt.domain.pageload.PageLoader;
import io.sitoolkit.wt.domain.pageload.selenium.SeleniumPageLoader;
import io.sitoolkit.wt.domain.testscript.Locator;
import io.sitoolkit.wt.domain.testscript.TestStep;
import java.util.Iterator;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class RadioCheckLoader
extends SeleniumPageLoader
implements PageLoader {
    @Override
    protected void loadForm(PageContext ctx, ElementId formId, WebElement element) {
        WebElement choice;
        WebElement choiceLabel;
        String name = element.getAttribute("name");
        if (ctx.containsName(name)) {
            return;
        }
        int caseNo = 1;
        TestStep step = null;
        Iterator iterator = this.driver.findElements(By.name(name)).iterator();
        while (iterator.hasNext() && (choiceLabel = this.findLabelByForId((choice = (WebElement)iterator.next()).getAttribute("id"))) != null) {
            if (step == null) {
                step = ctx.create();
                step.setOperationName("choose");
                step.setLocator(Locator.build("name", name));
                step.setDataType("label");
                ctx.add(this.convert(element.getLocation()), step, formId);
            }
            step.setTestData("00" + Integer.toString(caseNo++), choiceLabel.getText());
        }
    }

    @Override
    protected By by() {
        return By.cssSelector("input[type='radio'],input[type='checkbox']");
    }
}

