/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperation;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.PropertyManager;
import io.sitoolkit.wt.infra.RegexHelper;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class WaitOperation
extends SeleniumOperation {
    @Resource
    PropertyManager pm;

    @Override
    public void execute(TestStep testStep, SeleniumOperationContext ctx) {
        int timeout = this.pm.getTimeout();
        int waitSpan = this.pm.getWaitSpan();
        ctx.info("wait", testStep.getItemName(), testStep.getLocator(), testStep.getValue(), timeout / 1000);
        int count = timeout / waitSpan;
        for (int i = 0; i < count; ++i) {
            String text = this.findElement(testStep.getLocator()).getText();
            if (RegexHelper.matches(testStep.getValue(), text)) break;
            try {
                Thread.sleep(waitSpan);
                continue;
            }
            catch (InterruptedException e) {
                this.log.warn("thread.sleep.error", e);
            }
        }
    }
}

