/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperation;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.VerifyException;
import io.sitoolkit.wt.infra.resource.MessageManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.springframework.stereotype.Component;

@Component
public class VerifySelectOperation
extends SeleniumOperation {
    private static Map<String, OptionSupport> map = new HashMap<String, OptionSupport>();

    @Override
    public void execute(TestStep testStep, SeleniumOperationContext ctx) {
        Object[] expectedValues = testStep.getValues();
        WebElement element = this.findElement(testStep.getLocator());
        Select select = new Select(element);
        ctx.info(element, "verify.select", testStep.getItemName(), testStep.getLocator(), Arrays.toString(expectedValues));
        OptionSupport support = map.get(testStep.getDataType());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < select.getOptions().size(); ++i) {
            WebElement option = select.getOptions().get(i);
            if (support.expectsSelected((String[])expectedValues, i, option)) {
                if ("true".equalsIgnoreCase(option.getAttribute("selected"))) continue;
                sb.append(this.toMessage(i, option));
                sb.append("\u306f\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                continue;
            }
            if (!"true".equalsIgnoreCase(option.getAttribute("selected"))) continue;
            sb.append(this.toMessage(i, option));
            sb.append("\u306f\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        if (sb.length() > 0) {
            throw new VerifyException(MessageManager.getMessage("verify.select.unmatch"), testStep.getItemName(), testStep.getLocator(), sb.toString());
        }
    }

    String toMessage(int index, WebElement option) {
        return index + "\u756a\u76ee\u306e\u9078\u629e\u80a2[" + option.getText() + "](\u5024= " + option.getAttribute("value") + ")";
    }

    static {
        map.put("index", new OptionSupport(){

            @Override
            public boolean expectsSelected(String[] expectedValues, int index, WebElement option) {
                return ArrayUtils.contains(expectedValues, Integer.toString(index + 1));
            }
        });
        map.put("label", new OptionSupport(){

            @Override
            public boolean expectsSelected(String[] expectedValues, int index, WebElement option) {
                return ArrayUtils.contains(expectedValues, option.getText());
            }
        });
        map.put("value", new OptionSupport(){

            @Override
            public boolean expectsSelected(String[] expectedValues, int index, WebElement option) {
                return ArrayUtils.contains(expectedValues, option.getAttribute("value"));
            }
        });
        map.put("", map.get("value"));
    }

    static interface OptionSupport {
        public boolean expectsSelected(String[] var1, int var2, WebElement var3);
    }
}

