/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperation;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.RegexHelper;
import io.sitoolkit.wt.infra.VerifyException;
import io.sitoolkit.wt.infra.resource.MessageManager;
import org.openqa.selenium.WebElement;
import org.springframework.stereotype.Component;

@Component
public class VerifyOperation
extends SeleniumOperation {
    @Override
    public void execute(TestStep testStep, SeleniumOperationContext ctx) {
        String expected = testStep.getValue();
        WebElement element = this.findElement(testStep.getLocator());
        String actual = this.getActual(element, testStep);
        ctx.info(element, "verify", testStep.getItemName(), testStep.getLocator(), expected);
        if (!RegexHelper.matches(testStep.getValue(), actual)) {
            throw new VerifyException(MessageManager.getMessage("verify.unmatch"), testStep.getItemName(), testStep.getLocator(), actual, expected);
        }
    }

    protected String getActual(WebElement element, TestStep testStep) {
        return element.getText();
    }
}

