/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperation;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.tester.TestContext;
import io.sitoolkit.wt.domain.testscript.TestStep;
import javax.annotation.Resource;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.springframework.stereotype.Component;

@Component
public class StoreElementIndexOperation
extends SeleniumOperation {
    @Resource
    TestContext context;
    private int indexDefault = 1;

    @Override
    public void execute(TestStep testStep, SeleniumOperationContext ctx) {
        WebElement element = this.findElement(testStep.getLocator());
        Object parent = element.findElement(By.xpath(".."));
        int idx = this.getIndexDefault();
        for (WebElement child : parent.findElements(By.xpath("/*"))) {
            if (element.getLocation().equals(child.getLocation())) break;
            ++idx;
        }
        ctx.info(element, "element.index", testStep.getItemName(), testStep.getLocator(), idx);
        this.context.addParam(testStep.getDataType(), idx);
    }

    public int getIndexDefault() {
        return this.indexDefault;
    }

    public void setIndexDefault(int indexDefault) {
        this.indexDefault = indexDefault;
    }
}

