/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.evidence.ElementPosition;
import io.sitoolkit.wt.domain.evidence.LogLevelVo;
import io.sitoolkit.wt.domain.evidence.LogRecord;
import io.sitoolkit.wt.domain.evidence.MessagePattern;
import io.sitoolkit.wt.domain.evidence.selenium.ElementPositionSupport2;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.log.SitLogger;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;

public class SeleniumOperationContext {
    private SitLogger logger;
    private ElementPositionSupport2 elementPositionSupport;
    private TestStep testStep;
    private List<LogRecord> records = new ArrayList<LogRecord>();

    public void info(WebElement element, MessagePattern pattern, Object ... params) {
        this.records.add(LogRecord.create(this.logger, this.conv(element), this.testStep, pattern, params));
    }

    public void info(WebElement element, String pattern, Object ... params) {
        this.records.add(LogRecord.create(this.logger, this.elementPositionSupport.get(element), this.testStep, pattern, params));
    }

    public void info(String pattern, Object ... params) {
        this.records.add(LogRecord.create(this.logger, LogLevelVo.INFO, this.testStep, pattern, params));
    }

    public void info(MessagePattern pattern, Object ... params) {
        this.info(null, pattern, params);
    }

    private ElementPosition conv(WebElement element) {
        if (element == null) {
            return ElementPosition.EMPTY;
        }
        return this.elementPositionSupport.get(element);
    }

    public void addOperatedElement(List<WebElement> elements) {
        if (this.records.isEmpty()) {
            return;
        }
        LogRecord log = this.records.get(this.records.size() - 1);
        for (WebElement element : elements) {
            ElementPosition position = this.elementPositionSupport.get(element);
            if (ElementPosition.EMPTY == position) continue;
            position.setNo(this.testStep.getNo());
            log.getPositions().add(position);
        }
    }

    public SitLogger getLogger() {
        return this.logger;
    }

    public void setLogger(SitLogger logger) {
        this.logger = logger;
    }

    public TestStep getTestStep() {
        return this.testStep;
    }

    public void setTestStep(TestStep testStep) {
        this.testStep = testStep;
    }

    public List<LogRecord> getRecords() {
        return this.records;
    }

    public void setElementPositionSupport(ElementPositionSupport2 elementPositionSupport) {
        this.elementPositionSupport = elementPositionSupport;
    }
}

