/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.evidence.selenium.ElementPositionSupport2;
import io.sitoolkit.wt.domain.operation.Operation;
import io.sitoolkit.wt.domain.operation.OperationResult;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.testscript.Locator;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.ElementNotFoundException;
import io.sitoolkit.wt.infra.PropertyManager;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.util.List;
import javax.annotation.Resource;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public abstract class SeleniumOperation
implements Operation {
    @Resource
    PropertyManager pm;
    protected final SitLogger log = SitLoggerFactory.getLogger(this.getClass());
    @Resource
    protected WebDriver seleniumDriver;
    @Resource
    ElementPositionSupport2 position;

    @Override
    public OperationResult operate(TestStep testStep) {
        SeleniumOperationContext ctx = new SeleniumOperationContext();
        ctx.setLogger(this.log);
        ctx.setTestStep(testStep);
        ctx.setElementPositionSupport(this.position);
        this.execute(testStep, ctx);
        OperationResult result = new OperationResult();
        result.setRecords(ctx.getRecords());
        return result;
    }

    protected abstract void execute(TestStep var1, SeleniumOperationContext var2);

    protected By by(Locator locator) {
        switch (locator.getTypeVo()) {
            case css: {
                return By.cssSelector(locator.getValue());
            }
            case name: {
                return By.name(locator.getValue());
            }
            case xpath: {
                return By.xpath(locator.getValue());
            }
            case link: {
                return By.linkText(locator.getValue());
            }
            case tag: {
                return By.tagName(locator.getValue());
            }
        }
        return By.id(locator.getValue());
    }

    protected WebElement findElement(Locator locator) {
        try {
            return this.seleniumDriver.findElement(this.by(locator));
        }
        catch (NoSuchElementException e) {
            throw ElementNotFoundException.create(locator, e);
        }
    }

    protected List<WebElement> findElements(Locator locator) {
        try {
            return this.seleniumDriver.findElements(this.by(locator));
        }
        catch (NoSuchElementException e) {
            throw ElementNotFoundException.create(locator, e);
        }
    }

    protected boolean setChecked(WebElement checkElement, WebElement clickElement, boolean checked) {
        this.log.debug("check.element", checkElement, clickElement, checked);
        if (checkElement.isSelected() != checked) {
            this.click(clickElement);
            return true;
        }
        return false;
    }

    protected void click(WebElement element) {
        if (this.pm.isEdgeDriver()) {
            JavascriptExecutor jse = (JavascriptExecutor)((Object)this.seleniumDriver);
            jse.executeScript("arguments[0].click();", element);
        } else {
            element.click();
        }
    }

    protected void input(WebElement element, String value) {
        if (this.pm.isEdgeDriver()) {
            JavascriptExecutor jse = (JavascriptExecutor)((Object)this.seleniumDriver);
            jse.executeScript("arguments[0].value = arguments[1];", element, value);
        } else {
            element.sendKeys(value);
        }
    }
}

