/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.evidence.MessagePattern;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperation;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.resource.MessageManager;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.springframework.stereotype.Component;

@Component
public class KeyOperation
extends SeleniumOperation {
    private static final String SPECIAL_KEY_PREFIX = "key_";

    @Override
    public void execute(TestStep testStep, SeleniumOperationContext ctx) {
        WebElement element = this.findElement(testStep.getLocator());
        ctx.info(element, MessagePattern.\u9805\u76ee\u306bXX\u3092YY\u3057\u307e\u3059, Arrays.toString(testStep.getValues()), MessageManager.getMessage("key.strok"));
        CharSequence[] chars = this.split(testStep.getValues());
        Keys.chord(chars);
    }

    CharSequence[] split(String[] values) {
        ArrayList<CharSequence> chars = new ArrayList<CharSequence>();
        for (String str : values) {
            if (str.startsWith(SPECIAL_KEY_PREFIX)) {
                str = StringUtils.substringAfter(str, SPECIAL_KEY_PREFIX);
                chars.add(Keys.valueOf(str.toUpperCase()));
                continue;
            }
            chars.add(str);
        }
        return chars.toArray(new CharSequence[chars.size()]);
    }
}

