/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxySettingService;
import io.sitoolkit.wt.domain.evidence.EvidenceManager;
import io.sitoolkit.wt.domain.evidence.MessagePattern;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperation;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.tester.TestContext;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.TestException;
import io.sitoolkit.wt.infra.resource.MessageManager;
import java.io.File;
import java.net.URL;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="downloadOperation")
public class DownloadOperation
extends SeleniumOperation {
    @Resource
    TestContext current;
    @Resource
    EvidenceManager em;

    @Override
    public void execute(TestStep testStep, SeleniumOperationContext ctx) {
        String urlString = testStep.getLocator().isNa() ? this.seleniumDriver.getCurrentUrl() : this.findElement(testStep.getLocator()).getAttribute("href");
        File downloadFile = this.em.buildDownloadFile(this.current.getScriptName(), this.current.getCaseNo(), this.current.getTestStepNo(), this.current.getItemName(), StringUtils.substringAfterLast(urlString, "/"));
        ctx.info(MessagePattern.\u9805\u76ee\u3092XX\u3057\u307e\u3059_URL_\u30a8\u30d3\u30c7\u30f3\u30b9, MessageManager.getMessage("download"), urlString, downloadFile.getAbsolutePath());
        try {
            URL targetUrl = new URL(urlString);
            ProxySettingService.getInstance().loadProxy();
            FileUtils.copyURLToFile(targetUrl, downloadFile);
        }
        catch (Exception exp) {
            throw new TestException(exp);
        }
    }
}

