/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.evidence.MessagePattern;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperation;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.resource.MessageManager;
import org.openqa.selenium.Alert;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.springframework.stereotype.Component;

@Component
public class DialogOperation
extends SeleniumOperation {
    @Override
    public void execute(TestStep testStep, SeleniumOperationContext ctx) {
        try {
            new WebDriverWait(this.seleniumDriver, this.pm.getDialogWaitInSecond()).until(ExpectedConditions.alertIsPresent());
            Alert alert = this.seleniumDriver.switchTo().alert();
            String alertText = alert.getText();
            testStep.getLocator().setValue(alertText);
            if (testStep.getDialogValue()) {
                ctx.info(MessagePattern.\u9805\u76ee\u3092XX\u3057\u307e\u3059, MessageManager.getMessage("accept"));
                alert.accept();
            } else {
                ctx.info(MessagePattern.\u9805\u76ee\u3092XX\u3057\u307e\u3059, MessageManager.getMessage("dismiss"));
                alert.dismiss();
            }
        }
        catch (UnsupportedOperationException e) {
            this.log.warn("unsupported.operation.error", this.getClass());
        }
    }
}

