/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.operation.DbVerifyLog;
import io.sitoolkit.wt.domain.operation.HtmlTable;
import io.sitoolkit.wt.domain.operation.Value;
import io.sitoolkit.wt.domain.operation.VerifyObj;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperation;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.TestException;
import io.sitoolkit.wt.infra.VerifyException;
import io.sitoolkit.wt.infra.template.TemplateEngine;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="dbverifyOperation")
public class DbVerifyOperation
extends SeleniumOperation {
    @Resource
    NamedParameterJdbcTemplate jdbcTemplate;
    @Resource
    HtmlTable htmlTable;
    @Resource
    DbVerifyLog dbVerifyLog;
    @Resource
    TemplateEngine templateEngine;
    private static final String PARAMETER = "param";
    private static final String VERIFY = "verify";

    @Override
    public void execute(TestStep testStep, SeleniumOperationContext ctx) {
        JsonReader reader = Json.createReader(new StringReader("{" + testStep.getValue() + "}"));
        JsonObject obj = reader.readObject();
        JsonObject paramObj = obj.getJsonObject(PARAMETER);
        JsonObject verifyObj = obj.getJsonObject(VERIFY);
        reader.close();
        String verifySql = this.writeSqlToString(testStep.getLocator().getValue()).toUpperCase();
        Map<String, String> paramMap = this.newUppercaseKeyMap(paramObj);
        Map<String, String> result = this.runVerifySql(verifySql, paramMap);
        Map<String, String> verifyMap = this.newUppercaseKeyMap(verifyObj);
        this.setUpLogInfo(verifyMap, result, verifySql, paramMap);
        String startLog = this.buildLog();
        ctx.info("msg", startLog);
        this.verify();
        String errorLog = this.buildErrorLog();
        String resultTable = this.buildHtmlTable(result, verifyMap);
        if (errorLog.length() != 0) {
            throw new VerifyException(StringUtils.join(errorLog, resultTable));
        }
        this.replaceLog(ctx, resultTable);
    }

    private void replaceLog(SeleniumOperationContext ctx, String resultTabel) {
        int currentIdx = ctx.getRecords().size() - 1;
        String currentLog = ctx.getRecords().get(currentIdx).getLog();
        String log = StringUtils.join(currentLog, resultTabel);
        ctx.getRecords().get(currentIdx).setLog(log);
    }

    private void setUpLogInfo(Map<String, String> verifyMap, Map<String, String> result, String locatorSql, Map<String, String> paramMap) {
        ArrayList<VerifyObj> verifyParams = new ArrayList<VerifyObj>();
        for (Map.Entry<String, String> entry : verifyMap.entrySet()) {
            VerifyObj obj = new VerifyObj();
            obj.setVerifyCol(entry.getKey());
            obj.setExpected(entry.getValue());
            obj.setActual(result.get(entry.getKey()));
            verifyParams.add(obj);
        }
        this.dbVerifyLog.setVerifyColList(verifyParams);
        this.dbVerifyLog.setVerifySql(locatorSql);
        this.dbVerifyLog.setVerifyParams(paramMap);
    }

    private void verify() {
        ArrayList<String> invalidList = new ArrayList<String>();
        ArrayList<VerifyObj> errorList = new ArrayList<VerifyObj>();
        ArrayList<String> mismatchedList = new ArrayList<String>();
        for (VerifyObj obj : this.dbVerifyLog.getVerifyColList()) {
            if (obj.getActual() == null) {
                invalidList.add(obj.getVerifyCol());
                continue;
            }
            if (obj.getActual().equals(obj.getExpected())) continue;
            errorList.add(obj);
            mismatchedList.add(obj.getVerifyCol());
        }
        this.dbVerifyLog.setInvalidCols(invalidList);
        this.dbVerifyLog.setVerifyErrs(errorList);
        this.dbVerifyLog.setMismatchedCols(mismatchedList);
    }

    private String buildLog() {
        this.dbVerifyLog.setTemplate("/evidence/evidence-template-dbverify-expected-list.vm");
        this.dbVerifyLog.setVar("expected");
        return this.templateEngine.writeToString(this.dbVerifyLog);
    }

    private String buildErrorLog() {
        this.dbVerifyLog.setTemplate("/evidence/evidence-template-dbverify-error-list.vm");
        this.dbVerifyLog.setVar("error");
        return this.templateEngine.writeToString(this.dbVerifyLog);
    }

    private String writeSqlToString(String sqlPath) {
        try {
            File sqlFile = new File(sqlPath).getAbsoluteFile();
            this.log.info("sql.load", sqlFile);
            return FileUtils.readFileToString(sqlFile, "UTF-8");
        }
        catch (IOException e) {
            throw new TestException(e);
        }
    }

    private Map<String, String> newUppercaseKeyMap(JsonObject jsonObj) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : jsonObj.entrySet()) {
            map.put(((String)entry.getKey()).toString().toUpperCase(), jsonObj.getString((String)entry.getKey()));
        }
        return map;
    }

    private Map<String, String> runVerifySql(String sql, Map<String, String> paramMap) {
        Map<Object, Object> tmpResult = new HashMap();
        try {
            this.log.info("sql.execute", sql, paramMap);
            tmpResult = this.jdbcTemplate.queryForMap(sql, paramMap);
        }
        catch (DataAccessException e) {
            throw new TestException(e);
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : tmpResult.entrySet()) {
            result.put(((String)entry.getKey()).toUpperCase(), entry.getValue().toString());
        }
        return result;
    }

    private String buildHtmlTable(Map<String, String> result, Map<String, String> verifyMap) {
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Value> values = new ArrayList<Value>();
        for (Map.Entry<String, String> entry : result.entrySet()) {
            String style = "";
            if (verifyMap.containsKey(entry.getKey())) {
                style = this.dbVerifyLog.getMismatchedCols().indexOf(entry.getKey()) > -1 ? "mismatched" : "verified";
            }
            columns.add(entry.getKey());
            values.add(new Value(entry.getValue().toString(), style));
        }
        this.htmlTable.setColumns(columns);
        this.htmlTable.setValues(values);
        return this.templateEngine.writeToString(this.htmlTable);
    }
}

