/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.appium;

import io.appium.java_client.AppiumDriver;
import io.sitoolkit.wt.domain.operation.ScreenshotOperation;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.io.File;
import javax.annotation.Resource;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public class HybridScreenshotOperation
implements ScreenshotOperation {
    private static final String CONTEXT_NATIVE_APP = "NATIVE_APP";
    private static final SitLogger LOG = SitLoggerFactory.getLogger(HybridScreenshotOperation.class);
    @Resource
    AppiumDriver<?> driver;

    @Override
    public File get() {
        if (this.driver instanceof TakesScreenshot) {
            String context = this.driver.getContext();
            if (CONTEXT_NATIVE_APP.equals(context)) {
                context = null;
            } else {
                this.driver.context(CONTEXT_NATIVE_APP);
            }
            File file = this.driver.getScreenshotAs(OutputType.FILE);
            if (context != null) {
                this.driver.getContextHandles();
                this.driver.context(context);
            }
            return file;
        }
        LOG.warn("driver.screenshot.error", this.driver.getClass().getName());
        return null;
    }

    @Override
    public File getWithDialog() {
        return this.get();
    }
}

