/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation;

import io.sitoolkit.wt.domain.operation.Operation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.support.SimpleBeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AssignableTypeFilter;

public class OperationConverter {
    @Resource
    ApplicationContext appCtx;
    private static final Map<String, String> beanMap;

    public Optional<Operation> convert(String operationName) {
        String beanName = beanMap.get(operationName);
        if (StringUtils.isEmpty(beanName)) {
            return Optional.empty();
        }
        return Optional.of((Operation)this.appCtx.getBean(beanMap.get(operationName)));
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        SimpleBeanDefinitionRegistry registry = new SimpleBeanDefinitionRegistry();
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(registry);
        AssignableTypeFilter tf = new AssignableTypeFilter(Operation.class);
        scanner.setIncludeAnnotationConfig(false);
        scanner.addIncludeFilter(tf);
        scanner.scan(OperationConverter.class.getPackage().getName());
        String[] beanNames = registry.getBeanDefinitionNames();
        int suffixLength = "Operation".length();
        for (String beanName : beanNames) {
            String operationName = beanName.substring(0, beanName.length() - suffixLength);
            map.put(operationName, beanName);
        }
        beanMap = Collections.unmodifiableMap(map);
    }
}

