/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation;

import io.sitoolkit.wt.domain.evidence.LogRecord;
import io.sitoolkit.wt.domain.operation.Operation;
import io.sitoolkit.wt.domain.operation.OperationResult;
import io.sitoolkit.wt.domain.tester.TestContext;
import io.sitoolkit.wt.domain.tester.TestContextListener;
import io.sitoolkit.wt.domain.testscript.TestScript;
import io.sitoolkit.wt.domain.testscript.TestScriptDao;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.PropertyManager;
import io.sitoolkit.wt.infra.TestException;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.resource.MessageManager;
import java.io.File;
import javax.annotation.Resource;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class IncludeOperation
implements Operation,
TestContextListener {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(IncludeOperation.class);
    private String sheetName = "TestScript";
    @Resource
    PropertyManager pm;
    @Resource
    ApplicationContext appCtx;
    @Resource
    TestContext current;
    @Resource
    TestScriptDao dao;

    @Override
    public OperationResult operate(TestStep testStep) {
        String testStepName = testStep.getLocator().getValue();
        LogRecord log = LogRecord.info(LOG, testStep, "script.execute", testStepName);
        this.current.backup();
        TestScript testScript = this.dao.load(new File(this.pm.getPageScriptDir(), testStepName), this.sheetName, false);
        this.current.setTestScript(testScript);
        this.current.reset();
        this.current.setCurrentIndex(this.current.getCurrentIndex() - 1);
        String caseNo = testStep.getValue();
        if (!testScript.containsCaseNo(caseNo)) {
            String msg = MessageManager.getMessage("case.number.error", caseNo) + testScript.getCaseNoMap().keySet();
            throw new TestException(msg);
        }
        this.current.setCaseNo(caseNo);
        this.current.setTestContextListener(this);
        return new OperationResult(log);
    }

    @Override
    public void onEnd(TestContext testContext) {
        testContext.restore();
        testContext.setTestContextListener(null);
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }
}

