/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.httpserver;

import com.sun.net.httpserver.HttpServer;
import io.sitoolkit.wt.app.httpserver.SitHttpServerConfig;
import io.sitoolkit.wt.domain.httpserver.ShutdownRequestHandler;
import io.sitoolkit.wt.domain.httpserver.SitHttpHandler;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.thread.DaemonThreadFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SitHttpServer {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(SitHttpServer.class);
    private HttpServer server;
    private boolean running = false;
    private int port;
    private String baseDir;
    private ApplicationContext appCtx;
    private ShutdownRequestHandler shutdownRequestHandler;

    private SitHttpServer(int port, String baseDir) {
        this.port = port;
        this.baseDir = baseDir;
        this.appCtx = new AnnotationConfigApplicationContext(SitHttpServerConfig.class);
        this.shutdownRequestHandler = this.appCtx.getBean(ShutdownRequestHandler.class);
    }

    public static SitHttpServer of(int port, String baseDir) {
        SitHttpServer instance = new SitHttpServer(port, baseDir);
        return instance;
    }

    public void start() throws IOException {
        ExecutorService serverExecutor = Executors.newCachedThreadPool(new DaemonThreadFactory());
        serverExecutor.submit(() -> {
            try {
                this.startServer();
            }
            catch (IOException e) {
                LOG.error("httpserver.start.failed", e);
                throw new UncheckedIOException(e);
            }
        });
        ExecutorService shutdownRequestMonitor = Executors.newCachedThreadPool(new DaemonThreadFactory());
        shutdownRequestMonitor.submit(() -> {
            this.running = true;
            if (this.doShutdown()) {
                this.stopNow();
            }
            serverExecutor.shutdownNow();
        });
    }

    private void startServer() throws IOException {
        SitHttpHandler handler = this.appCtx.getBean(SitHttpHandler.class);
        handler.setBaseDir(this.baseDir);
        this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
        this.server.createContext("/", handler);
        this.server.createContext("/stop", this.shutdownRequestHandler);
        this.server.start();
    }

    public void stop(int delay) {
        if (this.running) {
            this.server.stop(delay);
            this.running = false;
        }
    }

    public void stopNow() {
        this.stop(0);
    }

    private boolean doShutdown() {
        while (!this.needToStop()) {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                LOG.error("httpserver.monitoring.failed", e);
            }
        }
        return this.needToStop();
    }

    private boolean needToStop() {
        return this.shutdownRequestHandler.isRequested() || !this.running;
    }
}

