/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.evidence.selenium;

import io.sitoolkit.wt.domain.evidence.ScreenshotTaker;
import io.sitoolkit.wt.domain.evidence.ScreenshotTiming;
import io.sitoolkit.wt.domain.tester.TestContext;
import io.sitoolkit.wt.infra.PropertyManager;
import io.sitoolkit.wt.infra.TestException;
import io.sitoolkit.wt.infra.selenium.WebDriverUtils;
import java.awt.AWTException;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class SeleniumScreenshotTaker
extends ScreenshotTaker {
    @Resource
    TestContext current;
    @Resource
    WebDriver driver;
    @Resource
    TakesScreenshot takesScreenshot;
    @Resource
    PropertyManager pm;
    private boolean resizeWindow = false;
    private Robot robot;
    private long waitTimeout;
    private static final String WINDOW_SIZE_GET_SCRIPT;

    @PostConstruct
    public void init() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            this.log.warn("warn", e);
        }
        this.waitTimeout = this.pm.getImplicitlyWait() / 1000;
    }

    @Override
    protected byte[] getAsData(ScreenshotTiming timing) {
        if (ScreenshotTiming.ON_DIALOG.equals((Object)timing)) {
            return this.getDialogScreenshot();
        }
        if (Arrays.asList("chrome", "firefox", "edge").contains(this.pm.getDriverType())) {
            return this.getScreenshotWithAdjust();
        }
        return this.getScreenshot();
    }

    protected byte[] getScreenshot() {
        Dimension orgSize = null;
        if (this.resizeWindow) {
            orgSize = this.driver.manage().window().getSize();
            Dimension bodySize = this.driver.findElement(By.tagName("body")).getSize();
            this.driver.manage().window().setSize(bodySize);
            this.log.debug("bodySize {}", bodySize);
        }
        if (this.pm.isMsDriver() || this.pm.isFirefoxDriver()) {
            new WebDriverWait(this.driver, this.waitTimeout).until(new ExpectedCondition<Boolean>(){

                @Override
                public Boolean apply(WebDriver driver) {
                    try {
                        return ((JavascriptExecutor)((Object)driver)).executeScript("return document.readyState;", new Object[0]).equals("complete");
                    }
                    catch (WebDriverException e) {
                        SeleniumScreenshotTaker.this.log.debug("this exception is no effect for testing", e);
                        return true;
                    }
                }
            });
        }
        String data = this.takesScreenshot.getScreenshotAs(OutputType.BASE64);
        if (orgSize != null) {
            this.driver.manage().window().setSize(orgSize);
        }
        return Base64.getDecoder().decode(data);
    }

    protected byte[] getDialogScreenshot() {
        if (this.robot == null) {
            return null;
        }
        Rectangle windowRect = this.current.getWindowRect();
        if (windowRect == null || windowRect.isEmpty()) {
            return null;
        }
        new WebDriverWait(this.driver, this.pm.getDialogWaitInSecond()).until(ExpectedConditions.alertIsPresent());
        BufferedImage img = this.robot.createScreenCapture(windowRect);
        this.current.setWindowRect(null);
        return this.image2byteArray(img);
    }

    private byte[] getScreenshotWithAdjust() {
        WindowSize windowSize = this.getWindowSize();
        BufferedImage img = new BufferedImage(windowSize.getPageWidth(), windowSize.getPageHeight(), 2);
        Graphics graphics = img.getGraphics();
        if (windowSize.getWindowHeight() >= windowSize.getPageHeight() && windowSize.getWindowWidth() >= windowSize.getPageWidth()) {
            BufferedImage imageParts = this.getSizedScreenshot(windowSize.getWindowWidth(), windowSize.getWindowHeight());
            graphics.drawImage(imageParts, 0, 0, null);
        } else {
            this.drawWholePageScreenshot(windowSize, graphics);
        }
        return this.image2byteArray(img);
    }

    private void drawWholePageScreenshot(WindowSize windowSize, Graphics graphics) {
        for (int scrollPosY = 0; scrollPosY < windowSize.getPageHeight(); scrollPosY += windowSize.getWindowHeight()) {
            int drawPosY = this.calcDrawPos(windowSize.getWindowHeight(), windowSize.getPageHeight(), scrollPosY);
            for (int scrollPosX = 0; scrollPosX < windowSize.getPageWidth(); scrollPosX += windowSize.getWindowWidth()) {
                int drawPosX = this.calcDrawPos(windowSize.getWindowWidth(), windowSize.getPageWidth(), scrollPosX);
                this.scrollTo(scrollPosX, scrollPosY);
                BufferedImage imageParts = this.getSizedScreenshot(windowSize.getWindowWidth(), windowSize.getWindowHeight());
                graphics.drawImage(imageParts, drawPosX, drawPosY, null);
            }
        }
    }

    private int calcDrawPos(int windowLength, int pageLength, int scrollPos) {
        if (windowLength >= pageLength) {
            return 0;
        }
        if (scrollPos + windowLength >= pageLength) {
            return pageLength - windowLength;
        }
        return scrollPos;
    }

    private BufferedImage getSizedScreenshot(int windowWidth, int windowHeight) {
        try {
            BufferedImage imageParts = ImageIO.read(this.takesScreenshot.getScreenshotAs(OutputType.FILE));
            return this.changeImageSize(imageParts, windowWidth, windowHeight);
        }
        catch (Exception e) {
            throw new TestException(e);
        }
    }

    private BufferedImage changeImageSize(BufferedImage imageParts, int windowWidth, int windowHeight) {
        int width = imageParts.getWidth();
        int height = imageParts.getHeight();
        int newHeight = windowWidth * height / width;
        AffineTransformOp xform = new AffineTransformOp(AffineTransform.getScaleInstance((double)windowWidth / (double)width, (double)newHeight / (double)height), 2);
        BufferedImage sizeChangeImg = new BufferedImage(windowWidth, newHeight, imageParts.getType());
        xform.filter(imageParts, sizeChangeImg);
        return sizeChangeImg;
    }

    private WindowSize getWindowSize() {
        Map sizeMap = (Map)WebDriverUtils.executeScript(this.driver, WINDOW_SIZE_GET_SCRIPT, new Object[0]);
        return new WindowSize(((Long)sizeMap.get("pageHeight")).intValue(), ((Long)sizeMap.get("pageWidth")).intValue(), ((Long)sizeMap.get("windowHeight")).intValue(), ((Long)sizeMap.get("windowWidth")).intValue());
    }

    private void scrollTo(int x, int y) {
        JavascriptExecutor executor = (JavascriptExecutor)((Object)this.driver);
        String driverType = StringUtils.defaultString(this.pm.getDriverType());
        if ("edge".equals(driverType)) {
            executor.executeAsyncScript("window.scrollTo(" + x + ", " + y + ");window.requestAnimationFrame(() => { arguments[arguments.length - 1](); });", new Object[0]);
        } else {
            executor.executeScript("window.scrollTo(" + x + ", " + y + ");", new Object[0]);
        }
    }

    private byte[] image2byteArray(BufferedImage img) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new TestException(e);
        }
    }

    public void setResizeWindow(boolean resizeWindow) {
        this.resizeWindow = resizeWindow;
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("document.body.scrollHeight;");
        sb.append("return {");
        sb.append("pageHeight: document.body.scrollHeight,");
        sb.append("pageWidth: document.body.scrollWidth,");
        sb.append("windowHeight: document.documentElement.clientHeight,");
        sb.append("windowWidth: document.documentElement.clientWidth,");
        sb.append("};");
        WINDOW_SIZE_GET_SCRIPT = sb.toString();
    }

    private final class WindowSize {
        private final int pageHeight;
        private final int pageWidth;
        private final int windowHeight;
        private final int windowWidth;

        @Generated
        public WindowSize(int pageHeight, int pageWidth, int windowHeight, int windowWidth) {
            this.pageHeight = pageHeight;
            this.pageWidth = pageWidth;
            this.windowHeight = windowHeight;
            this.windowWidth = windowWidth;
        }

        @Generated
        public int getPageHeight() {
            return this.pageHeight;
        }

        @Generated
        public int getPageWidth() {
            return this.pageWidth;
        }

        @Generated
        public int getWindowHeight() {
            return this.windowHeight;
        }

        @Generated
        public int getWindowWidth() {
            return this.windowWidth;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WindowSize)) {
                return false;
            }
            WindowSize other = (WindowSize)o;
            if (this.getPageHeight() != other.getPageHeight()) {
                return false;
            }
            if (this.getPageWidth() != other.getPageWidth()) {
                return false;
            }
            if (this.getWindowHeight() != other.getWindowHeight()) {
                return false;
            }
            return this.getWindowWidth() == other.getWindowWidth();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPageHeight();
            result = result * 59 + this.getPageWidth();
            result = result * 59 + this.getWindowHeight();
            result = result * 59 + this.getWindowWidth();
            return result;
        }

        @Generated
        public String toString() {
            return "SeleniumScreenshotTaker.WindowSize(pageHeight=" + this.getPageHeight() + ", pageWidth=" + this.getPageWidth() + ", windowHeight=" + this.getWindowHeight() + ", windowWidth=" + this.getWindowWidth() + ")";
        }
    }
}

