/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.evidence.selenium;

import io.sitoolkit.wt.domain.evidence.ElementPosition;
import io.sitoolkit.wt.domain.evidence.ElementPositionStrategy;
import io.sitoolkit.wt.domain.evidence.selenium.ElementPositionSupportFactoryMobile;
import io.sitoolkit.wt.domain.evidence.selenium.ElementPositionSupportFactoryPc;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import javax.annotation.Resource;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ElementPositionSupport2 {
    protected final SitLogger log = SitLoggerFactory.getLogger(this.getClass());
    private boolean frameChanged = false;
    private double scale = 1.0;
    private Point basePosition;
    private WebElement currentFrame;
    private ElementPositionStrategy strategy;
    @Resource
    private WebDriver driver;

    public ElementPosition get(WebElement element) {
        if (element == null || !(this.driver instanceof TakesScreenshot)) {
            return ElementPosition.EMPTY;
        }
        if (this.strategy == null) {
            String driverType = System.getProperty("driver.type");
            ElementPositionStrategy elementPositionStrategy = this.strategy = "android".equals(driverType) || "ios".equals(driverType) ? ElementPositionSupportFactoryMobile.getStrategy(this.driver) : ElementPositionSupportFactoryPc.getStrategy(this.driver);
        }
        if (this.basePosition == null) {
            this.strategy.init(this, this.driver);
        }
        Point elementPos = element.getLocation();
        if (this.frameChanged) {
            this.basePosition = this.strategy.getCurrentBasePosition(this.driver, this.currentFrame);
            this.frameChanged = false;
        }
        this.log.debug("element.position", element, elementPos, this.basePosition);
        return new ElementPosition((double)elementPos.getX() * this.scale - (double)this.basePosition.getX(), (double)elementPos.getY() * this.scale - (double)this.basePosition.getY(), (double)element.getSize().getWidth() * this.scale, (double)element.getSize().getHeight() * this.scale);
    }

    public void setCurrentFrame(WebElement currentFrame) {
        this.currentFrame = currentFrame;
        this.frameChanged = true;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setBasePosition(Point basePosition) {
        this.basePosition = basePosition;
    }
}

