/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.evidence.appium;

import io.appium.java_client.AppiumDriver;
import io.sitoolkit.wt.domain.evidence.ScreenshotTaker;
import io.sitoolkit.wt.domain.evidence.ScreenshotTiming;
import java.util.Base64;
import javax.annotation.Resource;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public class HybridScreenshotTaker
extends ScreenshotTaker {
    private static final String CONTEXT_NATIVE_APP = "NATIVE_APP";
    @Resource
    AppiumDriver<?> driver;
    @Resource
    TakesScreenshot takesScreenshot;

    @Override
    protected byte[] getAsData(ScreenshotTiming timing) {
        String context = this.driver.getContext();
        if (CONTEXT_NATIVE_APP.equals(context)) {
            context = null;
        } else {
            this.driver.context(CONTEXT_NATIVE_APP);
        }
        String data = this.takesScreenshot.getScreenshotAs(OutputType.BASE64);
        if (context != null) {
            this.driver.getContextHandles();
            this.driver.context(context);
        }
        return Base64.getDecoder().decode(data);
    }
}

