/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.evidence;

import io.sitoolkit.wt.domain.evidence.ElementPosition;
import io.sitoolkit.wt.domain.evidence.LogLevelVo;
import io.sitoolkit.wt.domain.evidence.MessagePattern;
import io.sitoolkit.wt.domain.evidence.Screenshot;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.resource.MessageManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class LogRecord {
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private String no = "";
    private String timestamp;
    private String log;
    private String filePath;
    private List<ElementPosition> positions = new ArrayList<ElementPosition>();
    private Screenshot screenshot;
    private LogLevelVo logLevel;

    public LogRecord() {
        this.timestamp = DATE_FORMAT.format(new Date());
    }

    public LogRecord(String no, String log) {
        this();
        this.no = no;
        this.log = log;
    }

    private LogRecord(String no, String log, ElementPosition ... positions) {
        this(no, log);
        this.positions = new ArrayList<ElementPosition>();
        for (ElementPosition position : positions) {
            if (ElementPosition.EMPTY == position) continue;
            position.setNo(no);
            this.positions.add(position);
        }
    }

    public static LogRecord create(SitLogger logger, ElementPosition position, TestStep testStep, MessagePattern pattern, Object ... params) {
        Object[] newParams = new Object[]{testStep.getItemName(), testStep.getLocator()};
        newParams = ArrayUtils.addAll(newParams, params);
        return LogRecord.create(logger, position, testStep, pattern.getPattern(), newParams);
    }

    public static LogRecord create(SitLogger logger, ElementPosition position, TestStep testStep, String messageKey, Object ... params) {
        String msg = MessageManager.getMessage(messageKey, params);
        logger.infoMsg(msg);
        return new LogRecord(testStep.getNo(), msg, position);
    }

    public static LogRecord create(SitLogger logger, LogLevelVo logLevel, TestStep testStep, String messageKey, Object ... params) {
        String msg = MessageManager.getMessage(messageKey, params);
        switch (logLevel) {
            case INFO: {
                logger.infoMsg(msg);
                break;
            }
            case DEBUG: {
                logger.debugMsg(msg);
                break;
            }
            case ERROR: {
                logger.errorMsg(msg);
                break;
            }
            case WARN: {
                logger.warnMsg(msg);
                break;
            }
            default: {
                logger.infoMsg(msg);
            }
        }
        String testStepNo = testStep == null ? "xxx" : testStep.getNo();
        return new LogRecord(testStepNo, msg);
    }

    public static LogRecord info(SitLogger logger, TestStep testStep, MessagePattern messagePattern, Object ... params) {
        Object[] newParams = new Object[]{testStep.getItemName(), testStep.getLocator()};
        newParams = ArrayUtils.addAll(newParams, params);
        return LogRecord.info(logger, testStep, messagePattern.getPattern(), newParams);
    }

    public static LogRecord info(SitLogger logger, TestStep testStep, String messageKey, Object ... params) {
        return LogRecord.create(logger, LogLevelVo.INFO, testStep, messageKey, params);
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getNo() {
        return this.no;
    }

    public void setNo(String no) {
        this.no = no;
    }

    public LogLevelVo getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevelVo logLevel) {
        this.logLevel = logLevel;
    }

    public Screenshot getScreenshot() {
        return this.screenshot;
    }

    public void setScreenshot(Screenshot screenshot) {
        this.screenshot = screenshot;
    }

    public List<ElementPosition> getPositions() {
        return this.positions;
    }

    public void setPositions(List<ElementPosition> positions) {
        this.positions = positions;
    }
}

