/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.evidence;

import io.sitoolkit.wt.domain.evidence.Evidence;
import io.sitoolkit.wt.domain.evidence.EvidenceDir;
import io.sitoolkit.wt.domain.evidence.EvidenceNameConverter;
import io.sitoolkit.wt.domain.evidence.Screenshot;
import io.sitoolkit.wt.infra.PropertyManager;
import io.sitoolkit.wt.infra.PropertyUtils;
import io.sitoolkit.wt.infra.SitPathUtils;
import io.sitoolkit.wt.infra.TestException;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.util.infra.util.StrUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ResourceUtils;

public class EvidenceManager
implements ApplicationContextAware {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(EvidenceManager.class);
    private String templatePath = "/evidence/evidence-template.vm";
    private String[] evidenceResources = new String[]{"css/bootstrap.min.css", "css/style.css", "css/jquery-ui.min.css", "js/jquery.js", "js/numbering.js", "js/image.js", "js/jquery-ui.min.js"};
    private File evidenceDir;
    private File imgDir;
    private String logFilePath = "target/sit-wt.log";
    private Template tmpl;
    private ApplicationContext appCtx;
    private File downloadDir;
    @Resource
    PropertyManager pm;

    @PostConstruct
    public void init() {
        this.evidenceDir = new File(this.pm.getProjectDir(), EvidenceDir.getRoot() + "/evidence_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        this.evidenceDir.mkdirs();
        if (!this.evidenceDir.exists()) {
            throw new TestException("\u30a8\u30d3\u30c7\u30f3\u30b9\u51fa\u529b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + this.evidenceDir.getAbsoluteFile());
        }
        LOG.info("evidence.mkdirs", this.evidenceDir.getAbsolutePath());
        this.imgDir = new File(this.evidenceDir, "img");
        this.imgDir.mkdirs();
        if (!this.imgDir.exists()) {
            throw new TestException("\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u51fa\u529b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + this.imgDir.getAbsoluteFile());
        }
        this.downloadDir = new File(this.evidenceDir, "download");
        try {
            Properties prop = PropertyUtils.load("/velocity.properties", false);
            Velocity.init(prop);
            this.tmpl = Velocity.getTemplate(this.templatePath);
            for (String evidenceRes : this.evidenceResources) {
                URL url = ResourceUtils.getURL("classpath:evidence/" + evidenceRes);
                File dstFile = new File(this.evidenceDir, evidenceRes);
                FileUtils.copyURLToFile(url, dstFile);
            }
            this.copyEvidenceResources("img/icon/*", this.evidenceDir.getPath());
            this.copyEvidenceResources("css/images/*", this.evidenceDir.getPath());
        }
        catch (IOException e) {
            throw new TestException(e);
        }
        catch (Exception exp) {
            throw new TestException(exp);
        }
    }

    public void copyEvidenceResources(String locationPattern, String evidenceDir) throws IOException {
        org.springframework.core.io.Resource[] resources;
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (org.springframework.core.io.Resource res : resources = resolver.getResources("classpath:evidence/" + locationPattern)) {
            URL url = res.getURL();
            String evidenceRes = StringUtils.substringAfterLast(url.toString(), "evidence/");
            File dstFile = new File(FilenameUtils.concat(evidenceDir, evidenceRes));
            FileUtils.copyURLToFile(url, dstFile);
        }
    }

    public Evidence createEvidence(String scriptName, String caseNo) {
        Evidence evidence = this.appCtx.getBean(Evidence.class);
        evidence.setScriptName(scriptName);
        evidence.setCaseNo(caseNo);
        return evidence;
    }

    public void moveScreenshot(Evidence evidence, String testStepNo, String itemName) {
        Screenshot screenshot = evidence.getCurrentScreenshot();
        File file = screenshot.getFile();
        if (file == null) {
            return;
        }
        String screenshotFileName = EvidenceNameConverter.buildScreenshotFileName(evidence.getScriptName(), evidence.getCaseNo(), testStepNo, itemName, screenshot.getTiming().name());
        File dstFile = new File(this.imgDir, screenshotFileName);
        try {
            if (dstFile.exists()) {
                dstFile = new File(this.imgDir, dstFile.getName() + "_" + System.currentTimeMillis());
            }
            FileUtils.moveFile(file, dstFile);
            screenshot.setFile(dstFile);
            screenshot.setFilePath(SitPathUtils.relatvePath(this.evidenceDir, dstFile));
            LOG.info("screenshot.set", dstFile.getAbsolutePath());
        }
        catch (IOException e) {
            LOG.warn("screenshot.set.error", e);
        }
    }

    public Path flushEvidence(Evidence evidence) {
        String html = this.build(evidence);
        File htmlFile = new File(this.evidenceDir, EvidenceNameConverter.caseNo2evidence(evidence.getScriptName(), evidence.getCaseNo()));
        if (htmlFile.exists()) {
            htmlFile = new File(htmlFile.getParent(), System.currentTimeMillis() + "_" + htmlFile.getName());
        }
        LOG.info("evidence.output", htmlFile.getAbsolutePath());
        try {
            FileUtils.write(htmlFile, (CharSequence)html, "UTF-8");
            return htmlFile.toPath();
        }
        catch (Exception e) {
            throw new TestException("\u30a8\u30d3\u30c7\u30f3\u30b9\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    private String build(Evidence evidence) {
        VelocityContext context = new VelocityContext();
        StringWriter writer = new StringWriter();
        context.put("records", evidence.getRecords());
        context.put("caseNo", evidence.getCaseNo());
        context.put("testScriptName", evidence.getScriptName());
        context.put("result", evidence.hasError() ? "NG" : "");
        Future<?> screenshotRezeFuture = evidence.getScreenshotResizeFuture();
        if (screenshotRezeFuture != null) {
            try {
                screenshotRezeFuture.get(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOG.warn("screenshot.resize.wait.error", e);
                Thread.currentThread().interrupt();
            }
        }
        this.tmpl.merge(context, writer);
        return writer.toString();
    }

    @PreDestroy
    public void preDestory() {
        this.pm.save(this.evidenceDir);
        try {
            File logFile = new File(this.logFilePath);
            FileUtils.copyFileToDirectory(logFile, this.evidenceDir, true);
            logFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new TestException(e);
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext arg0) {
        this.appCtx = arg0;
    }

    public File buildDownloadFile(String scriptName, String caseNo, String testStepNo, String itemName, String baseFilename) {
        if (!this.downloadDir.exists()) {
            this.downloadDir.mkdirs();
            if (!this.downloadDir.exists()) {
                throw new TestException("\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + this.downloadDir.getAbsoluteFile());
            }
        }
        String fileName = StrUtils.sanitizeMetaCharacter(StringUtils.join((Object[])new String[]{scriptName, caseNo, testStepNo, itemName}, "_")) + "_" + baseFilename;
        return new File(this.downloadDir, fileName);
    }
}

