/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.evidence;

import io.sitoolkit.wt.domain.evidence.ElementPosition;
import io.sitoolkit.wt.domain.evidence.LogLevelVo;
import io.sitoolkit.wt.domain.evidence.LogRecord;
import io.sitoolkit.wt.domain.evidence.Screenshot;
import io.sitoolkit.wt.domain.evidence.ScreenshotTiming;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;

public class Evidence {
    private String scriptName;
    private String caseNo;
    private List<LogRecord> records = new ArrayList<LogRecord>();
    private List<ElementPosition> currentPositions = new ArrayList<ElementPosition>();
    private Screenshot currentScreenshot;
    private Future<?> screenshotResizeFuture;

    public void addLogRecord(LogRecord log) {
        this.records.add(log);
        this.currentPositions.addAll(log.getPositions());
    }

    public void addLogRecords(List<LogRecord> logs) {
        for (LogRecord log : logs) {
            this.addLogRecord(log);
        }
    }

    public void addElementPosition(ElementPosition pos) {
        this.currentPositions.add(pos);
    }

    public void addScreenshot(Screenshot screenshot, String resize) {
        LogRecord record = new LogRecord();
        this.records.add(record);
        this.currentScreenshot = screenshot;
        if (StringUtils.isNotEmpty(screenshot.getErrorMesage())) {
            record.setLog("\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + screenshot.getErrorMesage());
            return;
        }
        record.setScreenshot(this.currentScreenshot);
        if (screenshot.isResize()) {
            if (StringUtils.contains((CharSequence)resize, "\u5168")) {
                screenshot.setResize(false);
            }
        } else if (StringUtils.contains((CharSequence)resize, "\u7e2e")) {
            screenshot.setResize(true);
        }
    }

    public void commitScreenshot() {
        if (this.currentScreenshot == null) {
            return;
        }
        if (this.currentScreenshot.getFile() != null && !ScreenshotTiming.ON_DIALOG.equals((Object)this.currentScreenshot.getTiming())) {
            this.currentScreenshot.setPositions(this.currentPositions);
            this.screenshotResizeFuture = this.currentScreenshot.resize();
        }
        this.currentPositions = new ArrayList<ElementPosition>();
        this.currentScreenshot = null;
    }

    public boolean hasError() {
        for (LogRecord logRecord : this.records) {
            if (!LogLevelVo.ERROR.equals((Object)logRecord.getLogLevel())) continue;
            return true;
        }
        return false;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public String getCaseNo() {
        return this.caseNo;
    }

    public void setCaseNo(String caseNo) {
        this.caseNo = caseNo;
    }

    public List<LogRecord> getRecords() {
        return this.records;
    }

    public Screenshot getCurrentScreenshot() {
        return this.currentScreenshot;
    }

    public Future<?> getScreenshotResizeFuture() {
        return this.screenshotResizeFuture;
    }
}

