/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.app.test;

import io.sitoolkit.wt.app.compareevidence.DiffEvidenceGenerator;
import io.sitoolkit.wt.app.compareevidence.DiffEvidenceGeneratorConfig;
import io.sitoolkit.wt.app.selenium2script.Selenium2Script;
import io.sitoolkit.wt.app.test.TestCase;
import io.sitoolkit.wt.domain.evidence.EvidenceDir;
import io.sitoolkit.wt.domain.evidence.EvidenceOpener;
import io.sitoolkit.wt.domain.tester.TestEventListener;
import io.sitoolkit.wt.domain.tester.TestResult;
import io.sitoolkit.wt.domain.tester.Tester;
import io.sitoolkit.wt.domain.testscript.TestScript;
import io.sitoolkit.wt.domain.testscript.TestScriptCatalog;
import io.sitoolkit.wt.infra.ApplicationContextHelper;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.resource.MessageManager;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class TestRunner {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(TestRunner.class);

    public static void main(String[] args) {
        if (args.length < 1) {
            LOG.info("test.script.appoint");
            LOG.info("test.case", TestRunner.class.getName());
            System.exit(1);
        }
        boolean isParallel = Boolean.getBoolean("sitwt.parallel");
        boolean isEvidenceOpen = Boolean.getBoolean("sitwt.open-evidence");
        boolean isCompareScreenshot = Boolean.getBoolean("sitwt.compare-screenshot");
        TestRunner runner = new TestRunner();
        List<TestResult> results = runner.runScript(args[0], isParallel, isEvidenceOpen);
        for (TestResult resuls : results) {
            if (resuls.isSuccess()) continue;
            System.exit(2);
        }
        if (isCompareScreenshot) {
            AnnotationConfigApplicationContext appCtx = new AnnotationConfigApplicationContext(DiffEvidenceGeneratorConfig.class);
            DiffEvidenceGenerator generator = appCtx.getBean(DiffEvidenceGenerator.class);
            EvidenceDir targetDir = EvidenceDir.getLatest();
            EvidenceDir baseDir = EvidenceDir.baseEvidenceDir(null, targetDir.getBrowser());
            boolean compareSsSuccess = generator.generate(baseDir, targetDir, isCompareScreenshot);
            LOG.info("base.evidence.compare", compareSsSuccess ? MessageManager.getMessage("success") : MessageManager.getMessage("failure"));
            if (!compareSsSuccess) {
                EvidenceOpener opener = new EvidenceOpener();
                opener.openCompareNgEvidence(targetDir);
            }
        }
        System.exit(0);
    }

    public List<TestResult> runScript(String testCaseStr, boolean isParallel, boolean isEvidenceOpen) {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        ArrayList<TestCase> allTestCase = new ArrayList<TestCase>();
        for (String testCondition : testCaseStr.split(",")) {
            TestCase testCase = TestCase.parse(testCondition);
            if (!testCase.getScriptPath().endsWith(".side")) {
                allTestCase.add(testCase);
                continue;
            }
            this.selenium2scripts(testCase.getScriptPath()).forEach(testScript -> {
                TestCase seleniumTestCase = new TestCase();
                seleniumTestCase.setScriptPath(testScript.toAbsolutePath().toString());
                seleniumTestCase.setCaseNo("001");
                allTestCase.add(seleniumTestCase);
            });
        }
        if (isParallel) {
            results.addAll(this.runAllCasesInParallel(allTestCase, isEvidenceOpen));
        } else {
            results.addAll(this.runAllCase(allTestCase, isEvidenceOpen));
        }
        return results;
    }

    private List<Path> selenium2scripts(String seleniumScriptPath) {
        Selenium2Script s2s = Selenium2Script.initInstance();
        s2s.setOpenScript(false);
        s2s.setOverwriteScript(false);
        Path seleniumScript = Paths.get(seleniumScriptPath, new String[0]);
        List<Path> scripts = s2s.convertScriptFile(seleniumScript);
        s2s.backup(seleniumScript);
        return scripts;
    }

    private List<TestResult> runAllCase(List<TestCase> testCases, boolean isEvidenceOpen) {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        TestScriptCatalog catalog = ApplicationContextHelper.getBean(TestScriptCatalog.class);
        for (TestCase testCase : testCases) {
            String scriptPath = testCase.getScriptPath();
            String sheetName = testCase.getSheetName();
            String caseNo = testCase.getCaseNo();
            TestScript script = catalog.get(scriptPath, sheetName);
            if (StringUtils.isEmpty(caseNo)) {
                for (String caseNoInScript : script.getCaseNoMap().keySet()) {
                    results.add(this.runCase(scriptPath, sheetName, caseNoInScript));
                }
            } else {
                results.add(this.runCase(scriptPath, sheetName, caseNo));
            }
            if (!isEvidenceOpen) continue;
            EvidenceOpener opener = new EvidenceOpener();
            opener.openTarget(new File(scriptPath));
        }
        return results;
    }

    private List<TestResult> runAllCasesInParallel(List<TestCase> testCases, boolean isEvidenceOpen) {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        TestScriptCatalog catalog = ApplicationContextHelper.getBean(TestScriptCatalog.class);
        ExecutorService executor = Executors.newCachedThreadPool();
        for (TestCase testCase : testCases) {
            String scriptPath = testCase.getScriptPath();
            String sheetName = testCase.getSheetName();
            String caseNo = testCase.getCaseNo();
            TestScript script = catalog.get(scriptPath, sheetName);
            if (StringUtils.isEmpty(caseNo)) {
                ArrayList<String> caseNoList = new ArrayList<String>(script.getCaseNoMap().keySet());
                if (caseNoList.isEmpty()) {
                    LOG.warn("case.empty", scriptPath, sheetName);
                    continue;
                }
                String lastCaseNo = (String)caseNoList.get(caseNoList.size() - 1);
                caseNoList.remove(caseNoList.size() - 1);
                for (String caseNoInScript : caseNoList) {
                    executor.execute(() -> results.add(this.runCase(scriptPath, sheetName, caseNoInScript)));
                }
                results.add(this.runCase(scriptPath, sheetName, lastCaseNo));
            } else {
                executor.execute(() -> results.add(this.runCase(scriptPath, sheetName, caseNo)));
            }
            if (!isEvidenceOpen) continue;
            EvidenceOpener opener = new EvidenceOpener();
            opener.openTarget(new File(scriptPath));
        }
        executor.shutdown();
        try {
            executor.awaitTermination(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOG.warn("thread.sleep.exception", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TestResult runCase(String scriptPath, String sheetName, String caseNo) {
        LOG.info("run.case", scriptPath, sheetName, caseNo);
        Tester tester = ApplicationContextHelper.getBean(Tester.class);
        TestEventListener listener = ApplicationContextHelper.getBean(TestEventListener.class);
        tester.prepare(scriptPath, sheetName, caseNo);
        listener.before();
        TestResult result = null;
        try {
            result = tester.operate(caseNo);
            listener.after();
            tester.tearDown();
            if (result == null) return result;
        }
        catch (Throwable throwable) {
            listener.after();
            tester.tearDown();
            if (result == null) throw throwable;
            LOG.info("test.result", caseNo, result.isSuccess() ? MessageManager.getMessage("success") : MessageManager.getMessage("failure"));
            throw throwable;
        }
        LOG.info("test.result", caseNo, result.isSuccess() ? MessageManager.getMessage("success") : MessageManager.getMessage("failure"));
        return result;
    }
}

