/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.app.selenium2script;

import io.sitoolkit.wt.app.selenium2script.SeleniumTestScript;
import io.sitoolkit.wt.app.selenium2script.SeleniumTestStep;
import io.sitoolkit.wt.domain.testscript.Locator;
import io.sitoolkit.wt.domain.testscript.ScreenshotTiming;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.domain.testscript.TestStepInputType;
import io.sitoolkit.wt.infra.SitPathUtils;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SeleniumStepConverter
implements ApplicationContextAware {
    protected final SitLogger log = SitLoggerFactory.getLogger(this.getClass());
    protected ApplicationContext appCtx;
    private Map<String, String> seleniumIdeCommandMap;
    private Pattern screenshotPattern;
    private static final List<String> COMMANDS_TO_SKIP = Collections.unmodifiableList(Arrays.asList("chooseOkOnNextConfirmation", "chooseCancelOnNextConfirmation", "assertConfirmation", "storeWindowHandle"));
    private static final List<String> CONFIRMATION_COMMANDS = Collections.unmodifiableList(Arrays.asList("webdriverChooseOkOnVisibleConfirmation", "webdriverChooseCancelOnVisibleConfirmation"));

    public List<TestStep> convertTestScript(SeleniumTestScript seleniumTestScript, String caseNo) {
        ArrayList<TestStep> testStepList = new ArrayList<TestStep>();
        int stepNo = 1;
        for (SeleniumTestStep seleniumStep : seleniumTestScript.getTestStepList()) {
            String command = seleniumStep.getCommand();
            if (COMMANDS_TO_SKIP.contains(command)) continue;
            TestStep sitStep = new TestStep();
            testStepList.add(sitStep);
            sitStep.setCurrentCaseNo(caseNo);
            sitStep.setNo(Integer.toString(stepNo++));
            TestStepInputType inputType = this.convertInputType(seleniumStep);
            if (inputType == null) {
                sitStep.setLocator(Locator.build(null));
                continue;
            }
            sitStep.setOperationName(inputType.getOperationName());
            sitStep.setLocator(this.convertLocator(inputType, seleniumTestScript, seleniumStep));
            sitStep.setScreenshotTiming(this.convertScreenshotTiming(seleniumStep));
            String value = seleniumStep.getValue();
            if (CONFIRMATION_COMMANDS.contains(command)) {
                sitStep.setTestData(this.convertConfirmData(caseNo, command));
                continue;
            }
            this.setTestData(sitStep, inputType, caseNo, value);
        }
        return testStepList;
    }

    protected Map<String, String> createTestData(String caseNo, String data) {
        HashMap<String, String> testData = new HashMap<String, String>();
        testData.put(caseNo, data);
        return testData;
    }

    protected Map<String, String> convertConfirmData(String caseNo, String command) {
        String data = "webdriverChooseOkOnVisibleConfirmation".equals(command) ? "ok" : "cancel";
        return this.createTestData(caseNo, data);
    }

    protected void setTestData(TestStep testStep, TestStepInputType inputType, String caseNo, String value) {
        String data;
        if (inputType.getDataTypes().size() >= 2) {
            String[] pair = StringUtils.split(value, "=");
            testStep.setDataType(pair[0]);
            data = pair[1];
        } else {
            data = StringUtils.isBlank(value) ? "y" : value;
        }
        testStep.setTestData(this.createTestData(caseNo, data));
    }

    protected TestStepInputType convertInputType(SeleniumTestStep seleniumStep) {
        TestStepInputType inputType;
        String operationName = this.seleniumIdeCommandMap.get(seleniumStep.getCommand());
        if (operationName == null) {
            operationName = seleniumStep.getCommand();
        }
        if (TestStepInputType.na.equals((Object)(inputType = TestStepInputType.decode(operationName)))) {
            this.log.info("selenium.command.unmatched", seleniumStep.getCommand());
            return null;
        }
        return inputType;
    }

    protected Locator convertLocator(TestStepInputType inputType, SeleniumTestScript seleniumScript, SeleniumTestStep seleniumStep) {
        String target = seleniumStep.getTarget();
        if (TestStepInputType.open.equals((Object)inputType)) {
            String url = SitPathUtils.buildUrl(seleniumScript.getBaseUrl(), target);
            return Locator.build(url);
        }
        if (inputType.getLocatorTypes().contains(Locator.Type.link.name()) && target.startsWith("linkText=")) {
            return Locator.build(Locator.Type.link.toString(), StringUtils.removeStart(target, "linkText="));
        }
        if (TestStepInputType.switchWindow.equals((Object)inputType)) {
            return Locator.build(null);
        }
        return Locator.build(target);
    }

    protected String convertScreenshotTiming(SeleniumTestStep seleniumStep) {
        String command = StringUtils.defaultString(seleniumStep.getCommand());
        return this.screenshotPattern.matcher(command).matches() ? ScreenshotTiming.BEFORE.getLabel() : "";
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appCtx = applicationContext;
    }

    @Generated
    public void setSeleniumIdeCommandMap(Map<String, String> seleniumIdeCommandMap) {
        this.seleniumIdeCommandMap = seleniumIdeCommandMap;
    }

    @Generated
    public void setScreenshotPattern(Pattern screenshotPattern) {
        this.screenshotPattern = screenshotPattern;
    }
}

