/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.app.selenium2script;

import com.fasterxml.jackson.databind.JsonNode;
import io.sitoolkit.wt.app.config.ExtConfig;
import io.sitoolkit.wt.app.selenium2script.Selenium2ScriptConfig;
import io.sitoolkit.wt.app.selenium2script.SeleniumStepConverter;
import io.sitoolkit.wt.app.selenium2script.SeleniumTestScript;
import io.sitoolkit.wt.app.selenium2script.SeleniumTestStep;
import io.sitoolkit.wt.domain.testscript.TestScriptDao;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.JsonUtils;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.util.infra.util.StrUtils;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class Selenium2Script {
    protected final SitLogger log = SitLoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_CASE_NO = "001";
    public static final String SCRIPT_EXTENSION = "side";
    private static final String SELENIUM_SCRIPT_DIR = "testscript";
    private TestScriptDao dao;
    private SeleniumStepConverter seleniumStepConverter;
    private String outputDir = "testscript";
    private boolean openScript = true;
    private boolean overwriteScript = false;

    public static void main(String[] args) {
        Selenium2Script instance = Selenium2Script.initInstance();
        instance.setOverwriteScript(true);
        instance.execute();
    }

    public static Selenium2Script initInstance() {
        try (AnnotationConfigApplicationContext appCtx = new AnnotationConfigApplicationContext(Selenium2ScriptConfig.class, ExtConfig.class);){
            Selenium2Script selenium2Script = appCtx.getBean(Selenium2Script.class);
            return selenium2Script;
        }
    }

    public void execute() {
        List<Path> testScripts = this.convertScriptFiles();
        if (this.isOpenScript()) {
            this.openTestScripts(testScripts);
        }
    }

    private List<Path> convertScriptFiles() {
        File scriptDir = new File(this.getProjectDirectory(), SELENIUM_SCRIPT_DIR);
        if (!scriptDir.exists()) {
            return Collections.emptyList();
        }
        this.getOutputDirPath().toFile().mkdirs();
        ArrayList<Path> testScripts = new ArrayList<Path>();
        FileUtils.listFiles(scriptDir, new String[]{SCRIPT_EXTENSION}, true).forEach(seleniumScript -> {
            testScripts.addAll(this.convertScriptFile(seleniumScript.toPath()));
            this.backup(seleniumScript.toPath());
        });
        return testScripts;
    }

    public List<Path> convertScriptFile(Path sourcePath) {
        this.log.info("selenium.script.convert", sourcePath.toAbsolutePath());
        List<SeleniumTestScript> seleniumScripts = this.loadSeleniumScripts(sourcePath);
        return seleniumScripts.stream().map(seleniumScript -> {
            List<TestStep> testStepList = this.seleniumStepConverter.convertTestScript((SeleniumTestScript)seleniumScript, DEFAULT_CASE_NO);
            Path outputPath = this.buildOutputPath(sourcePath, seleniumScript.getName());
            this.dao.write(outputPath.toFile(), testStepList, this.overwriteScript);
            return outputPath;
        }).collect(Collectors.toList());
    }

    private Path buildOutputPath(Path sourcePath, String testName) {
        String baseName = FilenameUtils.getBaseName(sourcePath.toString());
        String fileName = baseName + "_" + StrUtils.sanitizeMetaCharacter(testName) + ".csv";
        return this.getOutputDirPath().resolve(fileName);
    }

    public void backup(Path seleniumScript) {
        Path bkFile = seleniumScript.resolveSibling(seleniumScript.getFileName() + ".bk");
        this.log.info("selenium.script.backup", seleniumScript.toAbsolutePath(), bkFile);
        try {
            Files.move(seleniumScript, bkFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void openTestScripts(List<Path> testScripts) {
        for (Path testScript : testScripts) {
            try {
                Desktop.getDesktop().open(testScript.toFile());
            }
            catch (IOException e) {
                this.log.error("open.script.error", e);
            }
        }
    }

    private Path getOutputDirPath() {
        return Paths.get(this.getProjectDirectory(), this.outputDir);
    }

    private String getProjectDirectory() {
        String dir = System.getProperty("sitwt.projectDirectory");
        return StringUtils.isEmpty(dir) ? "." : dir;
    }

    private List<SeleniumTestScript> loadSeleniumScripts(Path script) {
        ArrayList<SeleniumTestScript> scripts = new ArrayList<SeleniumTestScript>();
        JsonNode node = JsonUtils.readTree(script);
        String baseUrl = node.get("url").asText();
        for (JsonNode testNode : node.get("tests")) {
            scripts.add(this.loadSeleniumScript(testNode, baseUrl));
        }
        return scripts;
    }

    private SeleniumTestScript loadSeleniumScript(JsonNode testNode, String baseUrl) {
        SeleniumTestScript script = new SeleniumTestScript();
        script.setBaseUrl(baseUrl);
        script.setName(testNode.get("name").asText());
        for (JsonNode commandNode : testNode.get("commands")) {
            SeleniumTestStep testStep = new SeleniumTestStep();
            testStep.setCommand(commandNode.get("command").asText());
            testStep.setTarget(commandNode.get("target").asText());
            testStep.setValue(commandNode.get("value").asText());
            script.getTestStepList().add(testStep);
            this.log.debug("test.step.load", testStep.getCommand(), testStep.getTarget(), testStep.getValue());
        }
        return script;
    }

    @Generated
    public TestScriptDao getDao() {
        return this.dao;
    }

    @Generated
    public SeleniumStepConverter getSeleniumStepConverter() {
        return this.seleniumStepConverter;
    }

    @Generated
    public String getOutputDir() {
        return this.outputDir;
    }

    @Generated
    public boolean isOpenScript() {
        return this.openScript;
    }

    @Generated
    public boolean isOverwriteScript() {
        return this.overwriteScript;
    }

    @Generated
    public void setDao(TestScriptDao dao) {
        this.dao = dao;
    }

    @Generated
    public void setSeleniumStepConverter(SeleniumStepConverter seleniumStepConverter) {
        this.seleniumStepConverter = seleniumStepConverter;
    }

    @Generated
    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    @Generated
    public void setOpenScript(boolean openScript) {
        this.openScript = openScript;
    }

    @Generated
    public void setOverwriteScript(boolean overwriteScript) {
        this.overwriteScript = overwriteScript;
    }
}

