/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.app.script2java;

import io.sitoolkit.wt.app.config.ExtConfig;
import io.sitoolkit.wt.app.script2java.Script2JavaConfig;
import io.sitoolkit.wt.domain.testclass.TestClass;
import io.sitoolkit.wt.domain.testclass.TestClassNameConverter;
import io.sitoolkit.wt.domain.testscript.TestScript;
import io.sitoolkit.wt.domain.testscript.TestScriptDao;
import io.sitoolkit.wt.infra.SitPathUtils;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.template.TemplateEngine;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class Script2Java
implements ApplicationContextAware {
    protected final SitLogger log = SitLoggerFactory.getLogger(this.getClass());
    public static final String SYSPROP_TESTS_SCRIPT_PATH = "testsScriptPath";
    private static final String DEFAULT_TEST_SRC_DIR = "target/generated-test-sources/test/";
    private static final File DEFAULT_PROJECT_DIR = new File(".");
    private String testSrcDir = "target/generated-test-sources/test/";
    private String testScriptDirs = "testscript,target/testscript";
    private ApplicationContext appCtx;
    private TestScriptDao dao;
    private String timestampFileName = "timestamp.xml";
    private TemplateEngine templateEngine;
    private Properties timestampLog = new Properties();

    public static void main(String[] args) {
        System.exit(Script2Java.staticExecute(DEFAULT_TEST_SRC_DIR, DEFAULT_PROJECT_DIR));
    }

    public static int staticExecute(String testSrcDir, File basedir) {
        try (AnnotationConfigApplicationContext appCtx = new AnnotationConfigApplicationContext(Script2JavaConfig.class, ExtConfig.class);){
            Script2Java script2java = appCtx.getBean(Script2Java.class);
            script2java.setTestSrcDir(testSrcDir);
            int n = script2java.execute(basedir);
            return n;
        }
    }

    public int execute(File basedir) {
        this.log.info("msg", basedir.toString());
        this.loadTimestampFile();
        String scriptPathes = System.getProperty(SYSPROP_TESTS_SCRIPT_PATH);
        if (StringUtils.isNotEmpty(scriptPathes)) {
            for (String path : scriptPathes.split(",")) {
                this.generate(new File(path), ".", basedir);
            }
        } else {
            for (String testScriptDir : this.testScriptDirs.split(",")) {
                File testScriptDirF = new File(basedir, testScriptDir);
                if (!testScriptDirF.exists()) continue;
                this.log.info("test.script", testScriptDirF.getAbsolutePath());
                for (File scriptFile : FileUtils.listFiles(testScriptDirF, new String[]{"csv"}, true)) {
                    this.generate(scriptFile, testScriptDirF.getAbsolutePath(), basedir);
                }
            }
        }
        this.storeTimestampFile();
        return 0;
    }

    public void generate(File scriptFile, String testScriptDir, File basedir) {
        String storedLastModified;
        if (scriptFile.getName().startsWith("~$")) {
            this.log.debug("system.file.exclusion", scriptFile.getAbsolutePath());
            return;
        }
        String lastModified = Long.toString(scriptFile.lastModified());
        if (lastModified.equals(storedLastModified = this.timestampLog.getProperty(scriptFile.getAbsolutePath()))) {
            this.log.info("script.last", scriptFile.getAbsolutePath());
            return;
        }
        this.timestampLog.put(scriptFile.getAbsolutePath(), lastModified);
        this.log.info("script.load", scriptFile.getAbsolutePath());
        TestClass testClass = this.appCtx.getBean(TestClass.class);
        this.load(testClass, scriptFile, testScriptDir, basedir);
        TestScript testScript = this.dao.load(scriptFile, testClass.getSheetName(), true);
        testClass.getCaseNos().addAll(testScript.getCaseNoMap().keySet());
        this.templateEngine.write(testClass);
    }

    void load(TestClass testClass, File scriptFile, String testScriptDir, File basedir) {
        testClass.setScriptPath(SitPathUtils.relatvePath(basedir, scriptFile));
        testClass.setFileBase(TestClassNameConverter.script2Class(testClass.getScriptPath()));
        String scriptPathFromPkg = SitPathUtils.relatvePath(testScriptDir, scriptFile.getAbsolutePath());
        String pkgPath = FilenameUtils.getPath(scriptPathFromPkg);
        testClass.setOutDir(FilenameUtils.concat(this.testSrcDir, pkgPath));
        if (StringUtils.isEmpty(pkgPath)) {
            testClass.setPkg(null);
        } else {
            String pkg = pkgPath.replaceAll("[/|\\\\]", ".");
            pkg = StringUtils.strip(pkg, ".");
            testClass.setPkg(pkg);
        }
    }

    private void loadTimestampFile() {
        File timestampFile = new File(this.testSrcDir, this.timestampFileName);
        if (timestampFile.exists()) {
            try {
                this.timestampLog.loadFromXML(FileUtils.openInputStream(timestampFile));
            }
            catch (IOException e) {
                this.log.warn("timestamp.load.error", e);
            }
        }
    }

    private void storeTimestampFile() {
        File timestampFile = new File(this.testSrcDir, this.timestampFileName);
        try {
            this.timestampLog.storeToXML(FileUtils.openOutputStream(timestampFile, false), "");
        }
        catch (IOException e) {
            this.log.warn("timestamp.write.error", e);
        }
    }

    public String getTestSrcDir() {
        return this.testSrcDir;
    }

    public void setTestSrcDir(String testSrcDir) {
        this.testSrcDir = testSrcDir;
    }

    public String getTestScriptDir() {
        return this.testScriptDirs;
    }

    public void setTestScriptDir(String testScriptDir) {
        this.testScriptDirs = testScriptDir;
    }

    public TestScriptDao getDao() {
        return this.dao;
    }

    public void setDao(TestScriptDao dao) {
        this.dao = dao;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.appCtx = applicationContext;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }
}

