/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.app.page2script;

import io.sitoolkit.wt.app.config.ExtConfig;
import io.sitoolkit.wt.app.page2script.Page2ScriptConfig;
import io.sitoolkit.wt.domain.debug.TestScriptGenerateTool;
import io.sitoolkit.wt.domain.pageload.PageContext;
import io.sitoolkit.wt.domain.pageload.PageListener;
import io.sitoolkit.wt.domain.pageload.PageLoader;
import io.sitoolkit.wt.domain.testscript.TestScriptDao;
import io.sitoolkit.wt.infra.PropertyManager;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Scanner;
import javax.annotation.Resource;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class Page2Script
implements TestScriptGenerateTool,
ApplicationContextAware {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(Page2Script.class);
    private static final String MSG = "\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u306b\u51fa\u529b\u3059\u308b\u30da\u30fc\u30b8\u3067Enter\u30ad\u30fc\u3092\u30bf\u30a4\u30d7\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n\u7d42\u4e86\u3059\u308b\u5834\u5408\u306fq\u3092\u5165\u529b\u3057Enter\u30ad\u30fc\u3092\u30bf\u30a4\u30d7\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    private List<PageLoader> loaders;
    private PageListener listener;
    private TestScriptDao dao;
    private ApplicationContext appCtx;
    private String outputDir;
    private boolean openScript = true;
    private boolean isCli = true;
    private Path createFile;
    @Resource
    private PropertyManager pm;

    public static void main(String[] args) {
        System.exit(Page2Script.staticStart(true));
    }

    public static int staticStart(boolean openScript) {
        AnnotationConfigApplicationContext appCtx = new AnnotationConfigApplicationContext(Page2ScriptConfig.class, ExtConfig.class);
        Page2Script page2script = appCtx.getBean(Page2Script.class);
        page2script.setOpenScript(openScript);
        int ret = page2script.start();
        appCtx.close();
        return ret;
    }

    public int start() {
        try {
            this.listener.setUp();
            Scanner scan = new Scanner(System.in);
            LOG.info("browser.start.operation");
            if (this.isCli) {
                LOG.info("msg", MSG);
            }
            while (!"q".equalsIgnoreCase(scan.nextLine())) {
                this.generateFromPage();
                if (!this.isCli) continue;
                LOG.info("msg", MSG);
            }
            scan.close();
        }
        catch (Exception e) {
            LOG.error("unexpected.error", e);
            int n = -1;
            return n;
        }
        finally {
            this.listener.tearDown();
        }
        return 0;
    }

    public void openBrowser(String baseUrl, String driverType) {
        this.pm.setBaseUrl(baseUrl);
        this.pm.setDriverType(driverType);
        this.listener.setUp();
        LOG.info("browser.start.operation");
    }

    @Override
    public void generateFromPage() {
        Object fileName;
        PageContext pageCtx = this.appCtx.getBean(PageContext.class);
        if (this.listener != null) {
            this.listener.setUpPage(pageCtx);
        }
        LOG.info("page.load.start", pageCtx.getTitle(), pageCtx.getUrl());
        for (PageLoader loader : this.loaders) {
            LOG.info("page.load.execute", loader.getClass().getName());
            loader.load(pageCtx);
        }
        if (this.listener != null) {
            this.listener.tearDownPage(pageCtx);
        }
        if (StringUtils.isEmpty((CharSequence)(fileName = pageCtx.getTitle()))) {
            fileName = pageCtx.getUrl();
            fileName = StringUtils.substringAfterLast((String)fileName, "/");
            fileName = StringUtils.substringBefore((String)fileName, "?");
        }
        fileName = (String)fileName + ".csv";
        String filePath = FilenameUtils.concat(this.outputDir, (String)fileName);
        filePath = this.dao.write(filePath, pageCtx.asList(), false);
        this.setCreateFile(Paths.get(filePath, new String[0]));
        if (this.isOpenScript()) {
            try {
                Desktop.getDesktop().open(new File(filePath));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public List<PageLoader> getLoaders() {
        return this.loaders;
    }

    public void setLoaders(List<PageLoader> loaders) {
        this.loaders = loaders;
    }

    public PageListener getListener() {
        return this.listener;
    }

    public void setListener(PageListener listener) {
        this.listener = listener;
    }

    public TestScriptDao getDao() {
        return this.dao;
    }

    public void setDao(TestScriptDao dao) {
        this.dao = dao;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appCtx = applicationContext;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public boolean isOpenScript() {
        return this.openScript;
    }

    public void setOpenScript(boolean openScript) {
        this.openScript = openScript;
    }

    public void setCli(boolean isCli) {
        this.isCli = isCli;
    }

    public Path getCreateFile() {
        return this.createFile;
    }

    public void setCreateFile(Path createFile) {
        this.createFile = createFile;
    }
}

