/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.app.compareevidence;

import io.sitoolkit.wt.app.compareevidence.MaskScreenshotGenerator;
import io.sitoolkit.wt.domain.evidence.EvidenceDir;
import io.sitoolkit.wt.domain.evidence.EvidenceOpener;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class MaskEvidenceGenerator {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(MaskEvidenceGenerator.class);

    public static void main(String[] args) {
        EvidenceDir targetDir = EvidenceDir.targetEvidenceDir(args[0]);
        MaskScreenshotGenerator mask = new MaskScreenshotGenerator();
        mask.generate(targetDir);
        MaskEvidenceGenerator evidence = new MaskEvidenceGenerator();
        evidence.generate(targetDir);
        EvidenceOpener opener = new EvidenceOpener();
        opener.openMaskEvidence(targetDir);
    }

    public void generate(EvidenceDir targetDir) {
        LOG.info("mask.evidence.generate");
        if (!targetDir.exists()) {
            LOG.error("evidence.error");
            return;
        }
        block0: for (File evidenceFile : targetDir.getEvidenceFiles()) {
            Map<String, File> ssMap = targetDir.getScreenshotFilesAsMap(evidenceFile.getName());
            for (Map.Entry<String, File> screenshot : ssMap.entrySet()) {
                if (!EvidenceDir.isMaskScreenshot(screenshot.getKey())) continue;
                this.generateMaskEvidence(evidenceFile, ssMap);
                continue block0;
            }
        }
    }

    void generateMaskEvidence(File evidenceFile, Map<String, File> ssMap) {
        File maskEvidence = new File(evidenceFile.getParent(), EvidenceDir.toMaskEvidenceName(evidenceFile.getName()));
        try {
            String evidenceHtml = FileUtils.readFileToString(evidenceFile, "UTF-8");
            for (Map.Entry<String, File> ssName : ssMap.entrySet()) {
                if (!EvidenceDir.isMaskScreenshot(ssName.getKey())) continue;
                evidenceHtml = StringUtils.replace(evidenceHtml, EvidenceDir.toBeforeMaskSsName(ssName.getKey()), ssName.getKey());
            }
            FileUtils.writeStringToFile(maskEvidence, evidenceHtml, "UTF-8");
            LOG.info("mask.evidence.generated", maskEvidence.getPath());
        }
        catch (IOException e) {
            LOG.error("evidence.generate.error", e);
        }
    }
}

