/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.app.compareevidence;

import io.sitoolkit.wt.app.compareevidence.DiffEvidenceGeneratorConfig;
import io.sitoolkit.wt.app.compareevidence.MaskEvidenceGenerator;
import io.sitoolkit.wt.app.compareevidence.MaskScreenshotGenerator;
import io.sitoolkit.wt.app.compareevidence.ScreenshotComparator;
import io.sitoolkit.wt.app.evidence.EvidenceReportEditor;
import io.sitoolkit.wt.domain.evidence.DiffEvidence;
import io.sitoolkit.wt.domain.evidence.EvidenceDir;
import io.sitoolkit.wt.domain.evidence.EvidenceOpener;
import io.sitoolkit.wt.domain.evidence.ReportOpener;
import io.sitoolkit.wt.infra.TestException;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.template.TemplateEngine;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.util.ResourceUtils;

public class DiffEvidenceGenerator {
    @Resource
    ApplicationContext appCtx;
    private static final SitLogger LOG = SitLoggerFactory.getLogger(DiffEvidenceGenerator.class);
    private String compareEvidenceResource = "js/diff.js";
    private DiffEvidence compareEvidence;
    private TemplateEngine templateEngine;
    private ScreenshotComparator screenshotComparator = new ScreenshotComparator();

    public static void main(String[] args) {
        AnnotationConfigApplicationContext appCtx = new AnnotationConfigApplicationContext(DiffEvidenceGeneratorConfig.class);
        DiffEvidenceGenerator generator = appCtx.getBean(DiffEvidenceGenerator.class);
        String targetPath = null;
        String basePath = null;
        int argCount = args.length;
        if (argCount == 2) {
            basePath = args[0];
            targetPath = args[1];
        } else if (argCount == 1) {
            targetPath = args[0];
        }
        EvidenceDir targetDir = EvidenceDir.targetEvidenceDir(targetPath);
        EvidenceDir baseDir = EvidenceDir.baseEvidenceDir(basePath, targetDir.getBrowser());
        generator.generate(baseDir, targetDir, false);
        EvidenceOpener opener = new EvidenceOpener();
        opener.openCompareEvidence(targetDir);
    }

    public static void staticExecute(EvidenceDir baseDir, EvidenceDir targetDir, boolean compareScreenshot, boolean evidenceOpen) {
        if (!baseDir.exists()) {
            LOG.error("base.evidence.error");
        } else {
            AnnotationConfigApplicationContext appCtx = new AnnotationConfigApplicationContext(DiffEvidenceGeneratorConfig.class);
            DiffEvidenceGenerator generator = appCtx.getBean(DiffEvidenceGenerator.class);
            boolean result = generator.generate(baseDir, targetDir, compareScreenshot);
            if (!result) {
                EvidenceReportEditor.staticExecute(targetDir);
                if (evidenceOpen) {
                    ReportOpener opener = appCtx.getBean(ReportOpener.class);
                    opener.open(targetDir);
                }
                throw new TestException("\u57fa\u6e96\u3068\u7570\u306a\u308b\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u304c\u5b58\u5728\u3057\u307e\u3059");
            }
        }
    }

    public boolean generate(EvidenceDir baseDir, EvidenceDir targetDir, boolean compareScreenshot) {
        LOG.info("compare.screenshot", baseDir.getDir(), targetDir.getDir());
        if (compareScreenshot) {
            MaskScreenshotGenerator mask = this.appCtx.getBean(MaskScreenshotGenerator.class);
            mask.generate(targetDir);
            MaskEvidenceGenerator evidence = this.appCtx.getBean(MaskEvidenceGenerator.class);
            evidence.generate(targetDir);
        }
        boolean allSsMatches = true;
        for (File evidenceFile : targetDir.getEvidenceFiles()) {
            if (compareScreenshot && !this.screenshotComparator.compare(baseDir, targetDir, evidenceFile)) {
                allSsMatches = false;
                try {
                    this.generateDiffEvidence(baseDir, evidenceFile, true);
                }
                catch (IOException e) {
                    LOG.error("compare.screenshot.error", e);
                    return allSsMatches;
                }
            }
            try {
                this.generateDiffEvidence(baseDir, evidenceFile, false);
                this.copyBaseScreenshots(baseDir, targetDir, evidenceFile);
            }
            catch (IOException e) {
                LOG.error("compare.screenshot.error", e);
                return allSsMatches;
            }
        }
        try {
            URL url = ResourceUtils.getURL("classpath:evidence/" + this.compareEvidenceResource);
            File dstFile = new File(targetDir.getDir(), this.compareEvidenceResource);
            FileUtils.copyURLToFile(url, dstFile);
        }
        catch (IOException e) {
            LOG.error("resource.copy.error", e);
        }
        catch (Exception exp) {
            LOG.error("proxy.error", exp);
        }
        return allSsMatches;
    }

    void generateDiffEvidence(EvidenceDir baseEvidenceDir, File evidenceFile, boolean withUnmatch) throws IOException {
        File baseEvidence = new File(baseEvidenceDir.getDir(), evidenceFile.getName());
        DiffEvidence diffEvidence = this.appCtx.getBean(DiffEvidence.class);
        this.load(diffEvidence, baseEvidenceDir, baseEvidence, evidenceFile, withUnmatch);
        this.templateEngine.write(diffEvidence);
        File maskEvidence = new File(evidenceFile.getParent(), EvidenceDir.toMaskEvidenceName(evidenceFile.getName()));
        if (!withUnmatch && maskEvidence.exists()) {
            this.generateMaskDiffEvidence(diffEvidence, baseEvidence, evidenceFile, withUnmatch);
        }
    }

    private void generateMaskDiffEvidence(DiffEvidence diffEvidence, File baseEvidenceFile, File evidenceFile, boolean withUnmatch) {
        this.load(diffEvidence, baseEvidenceFile, evidenceFile, withUnmatch);
        this.templateEngine.write(diffEvidence);
    }

    void load(DiffEvidence diffEvidence, EvidenceDir baseEvidenceDir, File baseEvidenceFile, File evidenceFile, boolean withUnmatch) throws IOException {
        diffEvidence.setEvidenceName(StringUtils.removeEnd(evidenceFile.getName(), ".html"));
        diffEvidence.setFileBase(EvidenceDir.getCompareEvidencePrefix(withUnmatch) + diffEvidence.getEvidenceName());
        diffEvidence.setOutDir(evidenceFile.getParent());
        diffEvidence.setLeftFileName(FilenameUtils.concat(baseEvidenceDir.getDir().getPath(), baseEvidenceFile.getName()));
        diffEvidence.setRightFileName(FilenameUtils.concat(evidenceFile.getParent(), evidenceFile.getName()));
        String leftHtmlTable = EvidenceDir.extractTable(baseEvidenceFile);
        leftHtmlTable = EvidenceDir.removeInputLine(leftHtmlTable);
        leftHtmlTable = EvidenceDir.replaceImgPath(leftHtmlTable);
        String rightHtmlTable = EvidenceDir.extractTable(evidenceFile);
        rightHtmlTable = EvidenceDir.removeInputLine(rightHtmlTable);
        if (withUnmatch) {
            leftHtmlTable = this.replaceImgName(leftHtmlTable, baseEvidenceFile);
            rightHtmlTable = this.replaceImgName(rightHtmlTable, evidenceFile);
        }
        diffEvidence.setLeftFile(leftHtmlTable);
        diffEvidence.setRightFile(rightHtmlTable);
    }

    void load(DiffEvidence diffEvidence, File baseEvidenceFile, File evidenceFile, boolean withUnmatch) {
        diffEvidence.setFileBase(EvidenceDir.toCompareMaskEvidenceName(diffEvidence.getEvidenceName()));
        diffEvidence.setLeftFile(this.replaceMaskImgName(diffEvidence.getLeftFile(), baseEvidenceFile, withUnmatch));
        diffEvidence.setRightFile(this.replaceMaskImgName(diffEvidence.getRightFile(), evidenceFile, withUnmatch));
    }

    private String replaceImgName(String text, File evidenceFile) {
        EvidenceDir evidenceDir = EvidenceDir.getInstance(evidenceFile.getParent());
        Map<String, File> imgMap = evidenceDir.getScreenshotFilesAsMap(evidenceFile.getName());
        for (Map.Entry<String, File> imgFile : imgMap.entrySet()) {
            String imgName = imgFile.getKey();
            if (EvidenceDir.isMaskScreenshot(imgName) || EvidenceDir.isUnmatchMaskScreenshot(imgName)) continue;
            String unmatchMaskImgName = EvidenceDir.toUnmatchMaskSsName(imgName);
            String unmatchImgName = EvidenceDir.toUnmatchSsName(imgName);
            String maskImgName = EvidenceDir.toMaskSsName(imgName);
            if (imgMap.get(unmatchMaskImgName) != null) {
                text = StringUtils.replace(text, imgName, unmatchMaskImgName);
                continue;
            }
            if (imgMap.get(unmatchImgName) != null) {
                text = StringUtils.replace(text, imgName, unmatchImgName);
                continue;
            }
            if (imgMap.get(maskImgName) == null) continue;
            text = StringUtils.replace(text, imgName, maskImgName);
        }
        return text;
    }

    private String replaceMaskImgName(String text, File evidenceFile, boolean withUnmatch) {
        EvidenceDir evidenceDir = EvidenceDir.getInstance(evidenceFile.getParent());
        Map<String, File> imgMap = evidenceDir.getScreenshotFilesAsMap(evidenceFile.getName());
        for (Map.Entry<String, File> imgFile : imgMap.entrySet()) {
            String maskImgName;
            String imgName = imgFile.getKey();
            if (EvidenceDir.isMaskScreenshot(imgName) || imgMap.get(maskImgName = EvidenceDir.toMaskSsName(imgName)) == null) continue;
            text = StringUtils.replace(text, imgName, maskImgName);
        }
        return text;
    }

    private void copyBaseScreenshots(EvidenceDir baseDir, EvidenceDir targetDir, File evidenceFile) {
        LOG.info("copy.base.screenshots");
        try {
            Map<String, File> baseSsMap = baseDir.getScreenshotFilesAsMap(evidenceFile.getName());
            for (Map.Entry<String, File> imgFile : baseSsMap.entrySet()) {
                FileUtils.copyFileToDirectory(imgFile.getValue(), targetDir.getImgBaseDir());
            }
        }
        catch (IOException e) {
            LOG.error("copy.screenshot.error", e);
        }
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public DiffEvidence getCompareEvidence() {
        return this.compareEvidence;
    }

    public void setCompareEvidence(DiffEvidence compareEvidence) {
        this.compareEvidence = compareEvidence;
    }
}

