/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.util.buildtoolhelper.proxysetting;

import io.sitoolkit.util.buildtoolhelper.config.SitoolkitProxyUtils;
import io.sitoolkit.util.buildtoolhelper.gradle.GradleProxyUtils;
import io.sitoolkit.util.buildtoolhelper.maven.MavenProxyUtils;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxyProtocol;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxySetting;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxySettingProcessClient;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxyUtils;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySettingService {
    private static final Logger log = LoggerFactory.getLogger(ProxySettingService.class);
    private static ProxySettingService instance = new ProxySettingService();
    private boolean loaded = false;

    private ProxySettingService() {
    }

    public static ProxySettingService getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProxy() {
        if (this.loaded) {
            return;
        }
        try {
            Optional<List> settings = Stream.of(SitoolkitProxyUtils.getInstance(), MavenProxyUtils.getInstance(), GradleProxyUtils.getInstance()).map(ProxyUtils::readProxySettings).filter(l -> !l.isEmpty()).findFirst();
            List<ProxySetting> proxySettings = null;
            if (settings.isPresent()) {
                proxySettings = settings.get();
            } else if (SystemUtils.IS_OS_WINDOWS) {
                ProxySettingProcessClient client = new ProxySettingProcessClient();
                proxySettings = client.getRegistryProxies();
            }
            if (proxySettings != null) {
                this.setProperties(proxySettings);
            }
        }
        catch (Exception exp) {
            log.warn("set proxy failed", exp);
        }
        finally {
            this.loaded = true;
        }
    }

    private void setProperties(List<ProxySetting> proxySettings) {
        if (proxySettings.isEmpty()) {
            log.info("proxy settings is disabled");
            return;
        }
        log.info("set proxy properties");
        proxySettings.stream().forEach(proxySetting -> {
            ProxyProtocol protocol = proxySetting.getProtocol();
            System.setProperty((Object)((Object)protocol) + ".proxyHost", proxySetting.getProxyHost());
            System.setProperty((Object)((Object)protocol) + ".proxyPort", proxySetting.getProxyPort());
            if (proxySetting.getNonProxyHosts() != null && !proxySetting.getNonProxyHosts().isEmpty()) {
                System.setProperty((Object)((Object)protocol) + "nonProxyHosts", proxySetting.getNonProxyHosts());
            }
        });
        this.setAuthProperties(proxySettings);
    }

    private void setAuthProperties(List<ProxySetting> proxySettings) {
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        Map<ProxyProtocol, ProxySetting> proxySettingMap = proxySettings.stream().collect(Collectors.toMap(ProxySetting::getProtocol, Function.identity()));
        Authenticator.setDefault(new SitoolkitProxyAuthenticator(proxySettingMap));
    }

    class SitoolkitProxyAuthenticator
    extends Authenticator {
        private Map<ProxyProtocol, ProxySetting> proxySettingMap;

        SitoolkitProxyAuthenticator(Map<ProxyProtocol, ProxySetting> proxySettingMap) {
            this.proxySettingMap = proxySettingMap;
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            String password;
            String user;
            String protocolStr = this.getRequestingURL().getProtocol();
            ProxyProtocol protocol = ProxyProtocol.getValue(protocolStr);
            ProxySetting proxySetting = this.proxySettingMap.get((Object)protocol);
            if (proxySetting == null) {
                log.warn("Proxy authentication setting not found: protocol '{}'", (Object)protocolStr);
                user = "";
                password = "";
            } else {
                user = proxySetting.getProxyUser();
                password = proxySetting.getProxyPassword();
            }
            return new PasswordAuthentication(user, password.toCharArray());
        }
    }
}

