/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.util.buildtoolhelper.process;

import io.sitoolkit.util.buildtoolhelper.UnExpectedException;
import io.sitoolkit.util.buildtoolhelper.process.ProcessCommand;
import io.sitoolkit.util.buildtoolhelper.process.ProcessConversation;
import io.sitoolkit.util.buildtoolhelper.process.ProcessExitCallback;
import io.sitoolkit.util.buildtoolhelper.process.StdoutListener;
import io.sitoolkit.util.buildtoolhelper.process.StdoutListenerContainer;
import io.sitoolkit.util.buildtoolhelper.process.StringBuilderStdoutListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessExecutor {
    private static final Logger log = LoggerFactory.getLogger(ProcessExecutor.class);
    private StringBuilderStdoutListener defaultStderrListener = new StringBuilderStdoutListener();

    public void execute(ProcessCommand command) {
        ProcessBuilder pb = this.toBuilder(command);
        Process process = null;
        try {
            process = pb.start();
            log.info("process {} starts {}", new Object[]{process, command.getWholeCommand()});
            this.scanStream(process.getInputStream(), this.stdoutListeners(command));
            this.scanStream(process.getErrorStream(), this.stderrListeners(command));
            this.waitForExit(process, command.getExitCallbacks());
        }
        catch (Exception e) {
            throw new UnExpectedException(e);
        }
        finally {
            ProcessConversation.destroy(process);
        }
    }

    public ProcessConversation executeAsync(ProcessCommand params) {
        ProcessConversation conversation = new ProcessConversation();
        Process process = null;
        ProcessBuilder pb = this.toBuilder(params);
        try {
            process = pb.start();
            conversation.init(process);
            log.info("process {} starts {}", new Object[]{process, params.getWholeCommand()});
            ExecutorService excutor = conversation.getExecutor();
            excutor.execute(() -> this.scanStream(conversation.getProcess().getInputStream(), this.stdoutListeners(params)));
            excutor.execute(() -> this.scanStream(conversation.getProcess().getErrorStream(), this.stderrListeners(params)));
            excutor.execute(() -> this.waitForExit(conversation.getProcess(), params.getExitCallbacks()));
        }
        catch (Exception e) {
            ProcessConversation.destroy(process);
            throw new UnExpectedException(e);
        }
        return conversation;
    }

    private List<StdoutListener> stdoutListeners(ProcessCommand params) {
        ArrayList<StdoutListener> stdoutListeners = new ArrayList<StdoutListener>();
        stdoutListeners.addAll(StdoutListenerContainer.getInstance().getStdoutListeners());
        stdoutListeners.addAll(params.getStdoutListeners());
        return stdoutListeners;
    }

    private List<StdoutListener> stderrListeners(ProcessCommand params) {
        ArrayList<StdoutListener> stderrListeners = new ArrayList<StdoutListener>();
        stderrListeners.add(this.defaultStderrListener);
        stderrListeners.addAll(StdoutListenerContainer.getInstance().getStderrListeners());
        stderrListeners.addAll(params.getStderrListeners());
        return stderrListeners;
    }

    private ProcessBuilder toBuilder(ProcessCommand params) {
        ProcessBuilder pb = new ProcessBuilder(params.getWholeCommand());
        pb.environment().putAll(params.getEnv());
        pb.directory(params.getCurrentDirectory().toFile());
        return pb;
    }

    private void scanStream(InputStream is, List<StdoutListener> listeners) {
        try (Scanner scanner = new Scanner(is);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                for (StdoutListener listener : listeners) {
                    listener.nextLine(line);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForExit(Process process, List<ProcessExitCallback> callbacks) {
        block7: {
            int exitCode = 0;
            try {
                exitCode = process.waitFor();
                log.info("process {} exits with code : {}", new Object[]{process, exitCode});
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                log.warn(e.getLocalizedMessage(), e);
            }
            finally {
                if (exitCode != 0) {
                    log.error("{} {}", (Object)System.lineSeparator(), (Object)this.defaultStderrListener);
                }
                if (callbacks == null) break block7;
                for (ProcessExitCallback callback : callbacks) {
                    callback.callback(exitCode);
                }
            }
        }
    }
}

