/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.util.buildtoolhelper.process;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessConversation {
    private static final Logger log = LoggerFactory.getLogger(ProcessConversation.class);
    private Process process;
    private PrintWriter processWriter;
    private ExecutorService executor;

    public void init(Process process) {
        this.process = process;
        this.processWriter = new PrintWriter(process.getOutputStream());
        this.executor = Executors.newCachedThreadPool();
    }

    public void input(String input) {
        this.processWriter.println(input);
        this.processWriter.flush();
    }

    public void destroy() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            log.warn(e.getLocalizedMessage(), e);
        }
        ProcessConversation.destroy(this.process);
    }

    public static void destroy(Process process) {
        if (process != null && process.isAlive()) {
            ProcessConversation.close(process.getInputStream());
            ProcessConversation.close(process.getOutputStream());
            ProcessConversation.close(process.getErrorStream());
            process.destroy();
        }
    }

    private static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            log.warn(e.getLocalizedMessage(), (Object)e.getMessage());
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }
}

