/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.util.buildtoolhelper.maven;

import io.sitoolkit.util.buildtoolhelper.maven.MavenUtils;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxyProtocol;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxySetting;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxyUtils;
import io.sitoolkit.util.buildtoolhelper.util.XmlUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MavenProxyUtils
implements ProxyUtils {
    private static final Logger log = LoggerFactory.getLogger(MavenProxyUtils.class);
    private static MavenProxyUtils instance = new MavenProxyUtils();

    private MavenProxyUtils() {
    }

    @Override
    public List<ProxySetting> readProxySettings() {
        Path settingFile = MavenUtils.getUserSettingFilePath();
        return this.readProxySettings(settingFile);
    }

    public List<ProxySetting> readProxySettings(Path settingFile) {
        if (!settingFile.toFile().exists()) {
            return Collections.emptyList();
        }
        try {
            Document document = MavenUtils.parseSettingFile(settingFile.toFile());
            XPath xpath = XPathFactory.newInstance().newXPath();
            ArrayList<ProxySetting> proxySettings = new ArrayList<ProxySetting>();
            NodeList proxyList = (NodeList)xpath.evaluate("/settings/proxies/proxy", document, XPathConstants.NODESET);
            for (int num = 0; num < proxyList.getLength(); ++num) {
                Element element = (Element)proxyList.item(num);
                String isActive = XmlUtil.getTextContentByTagName(element, "active");
                String protocol = XmlUtil.getTextContentByTagName(element, "protocol");
                String host = XmlUtil.getTextContentByTagName(element, "host");
                String port = XmlUtil.getTextContentByTagName(element, "port");
                String user = XmlUtil.getTextContentByTagName(element, "username");
                String password = XmlUtil.getTextContentByTagName(element, "password");
                String nonProxyHosts = XmlUtil.getTextContentByTagName(element, "nonProxyHosts");
                if (!"true".equals(isActive) || !ProxyProtocol.contains(protocol)) continue;
                ProxySetting proxySetting = new ProxySetting(ProxyProtocol.getValue(protocol), host, port, user, password, nonProxyHosts);
                proxySettings.add(proxySetting);
            }
            if (!proxySettings.isEmpty()) {
                log.info("Use maven proxy settings: {}", (Object)settingFile);
            }
            return proxySettings;
        }
        catch (Exception exp) {
            log.warn("read settings.xml failed", exp);
            return Collections.emptyList();
        }
    }

    public static MavenProxyUtils getInstance() {
        return instance;
    }
}

