/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.util.buildtoolhelper.maven;

import io.sitoolkit.util.buildtoolhelper.maven.MavenCommand;
import io.sitoolkit.util.buildtoolhelper.maven.MavenUtils;
import io.sitoolkit.util.buildtoolhelper.process.ProcessCommand;
import java.nio.file.Path;
import java.nio.file.Paths;

public class MavenProject {
    private Path projectDir;

    private MavenProject(Path projectDir) {
        this.projectDir = projectDir.toAbsolutePath().normalize();
    }

    public ProcessCommand mvnw(String ... args) {
        return new MavenCommand().currentDirectory(this.projectDir).args(args);
    }

    public boolean available() {
        return this.projectDir.resolve("pom.xml").toFile().exists();
    }

    public static MavenProject load(Path projectDir) {
        MavenProject mvnPrj = new MavenProject(projectDir);
        if (mvnPrj.available()) {
            MavenUtils.findAndInstall(projectDir);
        }
        return mvnPrj;
    }

    public static MavenProject load(String projectDir) {
        return MavenProject.load(Paths.get(projectDir, new String[0]));
    }
}

