/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.util.buildtoolhelper.gradle;

import io.sitoolkit.util.buildtoolhelper.UnExpectedException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradleUtils {
    private static final Logger log = LoggerFactory.getLogger(GradleUtils.class);
    private static String gradleCommand = "";

    public static String getCommand() {
        if (StringUtils.isEmpty(gradleCommand)) {
            throw new UnExpectedException("gradlew is not installed");
        }
        return gradleCommand;
    }

    public static synchronized void findAndInstall() {
        GradleUtils.findAndInstall(Paths.get(".", new String[0]));
    }

    public static synchronized void findAndInstall(Path baseDir) {
        if (StringUtils.isEmpty(gradleCommand) && StringUtils.isEmpty(gradleCommand = GradleUtils.find(baseDir))) {
            throw new UnsupportedOperationException("gradlew not installed and gradlew auto install is not supported");
        }
        log.info("gradlew command is '" + gradleCommand + "'");
    }

    public static String find(Path baseDir) {
        Path gradlew;
        Path path = gradlew = SystemUtils.IS_OS_WINDOWS ? baseDir.resolve("gradlew.bat") : baseDir.resolve("gradlew");
        if (gradlew.toFile().exists()) {
            return gradlew.toAbsolutePath().toString();
        }
        return "";
    }

    public static Path getUserSettingFilePath() {
        Path gradleUserHomeDir = Paths.get(System.getProperty("user.home"), ".gradle");
        return gradleUserHomeDir.resolve("gradle.properties");
    }
}

