/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.util.buildtoolhelper.gradle;

import io.sitoolkit.util.buildtoolhelper.gradle.GradleUtils;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxyProtocol;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxySetting;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxyUtils;
import io.sitoolkit.util.buildtoolhelper.util.PropertiesUtil;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradleProxyUtils
implements ProxyUtils {
    private static final Logger log = LoggerFactory.getLogger(GradleProxyUtils.class);
    private static GradleProxyUtils instance = new GradleProxyUtils();

    private GradleProxyUtils() {
    }

    @Override
    public List<ProxySetting> readProxySettings() {
        Path settingFile = GradleUtils.getUserSettingFilePath();
        return this.readProxySettings(settingFile);
    }

    public List<ProxySetting> readProxySettings(Path settingFile) {
        Properties properties;
        if (!settingFile.toFile().exists()) {
            return Collections.emptyList();
        }
        try {
            properties = PropertiesUtil.loadFile(settingFile);
        }
        catch (Exception e) {
            log.warn("Failed to read {}", (Object)settingFile, (Object)e);
            return Collections.emptyList();
        }
        List<ProxySetting> proxySettings = ProxyProtocol.getValueList().stream().map(protocol -> {
            String host = this.getProxyProperty(properties, (ProxyProtocol)((Object)protocol), "proxyHost");
            if (StringUtils.isEmpty(host)) {
                return null;
            }
            return new ProxySetting((ProxyProtocol)((Object)protocol), this.getProxyProperty(properties, (ProxyProtocol)((Object)protocol), "proxyHost"), this.getProxyProperty(properties, (ProxyProtocol)((Object)protocol), "proxyPort"), this.getProxyProperty(properties, (ProxyProtocol)((Object)protocol), "proxyUser"), this.getProxyProperty(properties, (ProxyProtocol)((Object)protocol), "proxyPassword"), this.getProxyProperty(properties, (ProxyProtocol)((Object)protocol), "nonProxyHosts"));
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!proxySettings.isEmpty()) {
            log.info("Use gradle proxy settings: {}", (Object)settingFile);
        }
        return proxySettings;
    }

    private String getProxyProperty(Properties properties, ProxyProtocol protocol, String attr) {
        return properties.getProperty("systemProp." + (Object)((Object)protocol) + "." + attr);
    }

    public static GradleProxyUtils getInstance() {
        return instance;
    }
}

