/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.util.buildtoolhelper.gradle;

import io.sitoolkit.util.buildtoolhelper.gradle.GradleCommand;
import io.sitoolkit.util.buildtoolhelper.gradle.GradleUtils;
import io.sitoolkit.util.buildtoolhelper.process.ProcessCommand;
import java.nio.file.Path;
import java.nio.file.Paths;

public class GradleProject {
    private Path projectDir;

    private GradleProject(Path projectDir) {
        this.projectDir = projectDir.toAbsolutePath().normalize();
    }

    public ProcessCommand gradlew(String ... args) {
        return new GradleCommand().currentDirectory(this.projectDir).args(args);
    }

    public boolean available() {
        return this.projectDir.resolve("build.gradle").toFile().exists();
    }

    public static GradleProject load(Path projectDir) {
        GradleProject grdlPrj = new GradleProject(projectDir);
        if (grdlPrj.available()) {
            GradleUtils.findAndInstall(projectDir);
        }
        return grdlPrj;
    }

    public static GradleProject load(String projectDir) {
        return GradleProject.load(Paths.get(projectDir, new String[0]));
    }
}

