/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.util.buildtoolhelper.config;

import io.sitoolkit.util.buildtoolhelper.config.SitoolkitConfig;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxyProtocol;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxySetting;
import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxyUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitoolkitProxyUtils
implements ProxyUtils {
    private static final Logger log = LoggerFactory.getLogger(SitoolkitProxyUtils.class);
    private static SitoolkitProxyUtils instance = new SitoolkitProxyUtils();

    private SitoolkitProxyUtils() {
    }

    @Override
    public List<ProxySetting> readProxySettings() {
        SitoolkitConfig config = SitoolkitConfig.getInstance();
        List<ProxySetting> proxySettings = ProxyProtocol.getValueList().stream().map(protocol -> {
            String host = config.getProperty("proxy." + (Object)protocol + ".host");
            if (StringUtils.isEmpty(host)) {
                return null;
            }
            return new ProxySetting((ProxyProtocol)((Object)protocol), host, config.getProperty("proxy." + (Object)protocol + ".port"), config.getProperty("proxy." + (Object)protocol + ".user"), config.getProperty("proxy." + (Object)protocol + ".password"), config.getProperty("proxy." + (Object)protocol + ".nonProxyHosts"));
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!proxySettings.isEmpty()) {
            log.info("Use SI-Toolkit proxy settings: {}", (Object)SitoolkitConfig.getInstance().getConfigFilePath());
        }
        return proxySettings;
    }

    public static SitoolkitProxyUtils getInstance() {
        return instance;
    }
}

